/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.client;

import com.idoox.transport.http.client.HttpConnection;
import com.idoox.transport.http.client.HttpPool;
import com.idoox.transport.util.SocketEx;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.config.HttpClientConfig;
import org.idoox.transport.server.ConnectionHandler;

public class HttpClient
implements Transport,
VetoableChangeListener {
    private static HashSet methods = new HashSet(4);
    public int DEFAULT_PORT = 80;
    protected Configurable config;
    protected HttpPool pool;
    protected int defaultTimeout = -1;
    protected boolean requestChunking = false;
    static /* synthetic */ Class class$org$idoox$transport$config$HttpClientConfig;

    public void load(Configurable c) {
        if (this.pool == null) {
            this.pool = new HttpPool(13);
        }
        HttpClientConfig config = (HttpClientConfig)c.narrow(class$org$idoox$transport$config$HttpClientConfig == null ? (class$org$idoox$transport$config$HttpClientConfig = HttpClient.class$("org.idoox.transport.config.HttpClientConfig")) : class$org$idoox$transport$config$HttpClientConfig);
        this.config = c;
        try {
            this.defaultTimeout = config.getDefaultTimeout();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.requestChunking = config.getRequestChunking();
        }
        catch (Exception e) {
            // empty catch block
        }
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost == null) {
            proxyHost = config.getProxyHost();
        }
        this.pool.setProxyHost(proxyHost);
        int proxyPort = Integer.getInteger("http.proxyPort", this.DEFAULT_PORT);
        try {
            int cfgProxyPort = config.getProxyPort();
            if (cfgProxyPort != -1) {
                proxyPort = cfgProxyPort;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pool.setProxyPort(proxyPort);
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts == null) {
            nonProxyHosts = config.getNonProxyHosts();
        } else {
            if (nonProxyHosts.indexOf(42) != -1) {
                throw new RuntimeException(c.getName() + " transport doesn't support nonProxyHosts with wildcards");
            }
            nonProxyHosts = nonProxyHosts.replace('|', ',');
        }
        this.pool.setNonProxyHosts(nonProxyHosts);
        try {
            this.pool.setChunkSize(config.getChunkSize());
        }
        catch (Exception e) {
            // empty catch block
        }
        c.addVetoableChangeListener(this);
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.clear();
        }
        if (this.config != null) {
            this.config.removeVetoableChangeListener(this);
        }
    }

    public void start(URI endpoint) {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return false;
    }

    public ConnectionHandler setHandler(ConnectionHandler handler) {
        return null;
    }

    public ClientConnection newConnection(URI endpoint, TransportMethod method, Map properties) throws IOException {
        if (this.pool == null) {
            return null;
        }
        String server = endpoint.getHost();
        int port = endpoint.getPort();
        if (port <= 0) {
            port = this.DEFAULT_PORT;
        }
        if (server == null) {
            throw new IOException("Server name have to be specified for " + this.config.getName() + " transport");
        }
        return this.newConnection(this.pool.get(null, server, port, this.defaultTimeout, 0, properties), endpoint, method, properties);
    }

    protected HttpConnection newConnection(SocketEx socket, URI endpoint, TransportMethod method, Map properties) throws IOException {
        String value;
        boolean localRequestChunking = this.requestChunking;
        if (properties != null && (value = (String)properties.get("http.request.chunking")) != null) {
            localRequestChunking = Boolean.valueOf(value);
        }
        return new HttpConnection(socket, endpoint, method, localRequestChunking);
    }

    public Set getMethods() {
        return methods;
    }

    public int getType() {
        return 2;
    }

    public String getLocalPath(URI endpoint) {
        return null;
    }

    public Endpoint[] getAbsolutePath(String path) {
        return null;
    }

    public synchronized void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (event.getPropertyName().equals("defaultTimeout")) {
            this.defaultTimeout = event.getNewValue() != null ? (Integer)event.getNewValue() : -1;
        } else if (event.getPropertyName().equals("requestChunking")) {
            this.requestChunking = event.getNewValue() != null ? (Boolean)event.getNewValue() : false;
        } else if (event.getPropertyName().equals("proxyHost")) {
            this.pool.setProxyHost((String)event.getNewValue());
        } else if (event.getPropertyName().equals("proxyPort")) {
            if (event.getNewValue() != null) {
                this.pool.setProxyPort((Integer)event.getNewValue());
            } else {
                this.pool.setProxyPort(this.DEFAULT_PORT);
            }
        } else if (event.getPropertyName().equals("nonProxyHosts")) {
            this.pool.setNonProxyHosts((String)event.getNewValue());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        methods.add(TransportMethod.POST);
        methods.add(TransportMethod.GET);
        methods.add(TransportMethod.PUT);
        methods.add(TransportMethod.DELETE);
    }
}

