/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http;

import java.io.ByteArrayOutputStream;

class RestorableByteArrayOutputStream
extends ByteArrayOutputStream {
    private int initialSize;
    private int origSize;

    public RestorableByteArrayOutputStream() {
    }

    public RestorableByteArrayOutputStream(int size) {
        super(size);
        this.initialSize = size;
    }

    public void reset() {
        this.origSize = this.count;
        super.reset();
    }

    public void restore() {
        if (this.origSize > 0) {
            this.count = this.origSize;
        }
    }

    public void free() {
        this.reset();
        if (this.buf.length > this.initialSize) {
            this.buf = new byte[this.initialSize];
        }
    }
}

