/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http;

import com.idoox.transport.http.RestorableByteArrayOutputStream;
import com.idoox.transport.util.WriteLine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.idoox.util.RuntimeWrappedException;

public class ChunkableOutputStream
extends FilterOutputStream {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LAST_CHUNK;
    private boolean chunking = false;
    private boolean closed = false;
    private OutputStream rawOutput;
    private int chunkSize;
    public WriteLine line;

    public ChunkableOutputStream(OutputStream rawOutput, int chunkSize) {
        super(new RestorableByteArrayOutputStream(chunkSize));
        this.rawOutput = rawOutput;
        this.chunkSize = chunkSize;
        this.line = new WriteLine(rawOutput);
    }

    public OutputStream getRawStream() {
        return this.rawOutput;
    }

    public void setRawStream(OutputStream rawOutput) {
        this.rawOutput = rawOutput;
        this.line.setOutputStream(rawOutput);
    }

    public OutputStream getBufferStream() {
        return this.out;
    }

    public void setBufferStream(OutputStream buffer) {
        this.out = buffer;
    }

    public boolean isChunking() {
        return this.chunking;
    }

    public void setChunking(boolean chunking) {
        this.chunking = chunking;
        this.closed = false;
    }

    public int getContentLength() {
        return ((RestorableByteArrayOutputStream)this.out).size();
    }

    public void write(int b) throws IOException {
        if (this.chunking && ((RestorableByteArrayOutputStream)this.out).size() + 1 > this.chunkSize) {
            this.flush();
        }
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.chunking && ((RestorableByteArrayOutputStream)this.out).size() + len > this.chunkSize) {
            int leftSpace = this.chunkSize - ((RestorableByteArrayOutputStream)this.out).size();
            this.out.write(b, off, leftSpace);
            this.flush();
            this.write(b, off + leftSpace, len - leftSpace);
        } else {
            this.out.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        if (this.chunking && ((RestorableByteArrayOutputStream)this.out).size() > 0) {
            this.line.write(Integer.toHexString(this.getContentLength()), true);
            ((RestorableByteArrayOutputStream)this.out).writeTo(this.rawOutput);
            this.rawOutput.write(CRLF);
            ((RestorableByteArrayOutputStream)this.out).reset();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        if (!this.chunking) {
            if (((RestorableByteArrayOutputStream)this.out).size() > 0) {
                ((RestorableByteArrayOutputStream)this.out).writeTo(this.rawOutput);
            }
        } else {
            this.rawOutput.write(LAST_CHUNK);
        }
        this.rawOutput.flush();
        ((RestorableByteArrayOutputStream)this.out).free();
        this.closed = true;
    }

    public void restore() {
        ((RestorableByteArrayOutputStream)this.out).restore();
    }

    static {
        try {
            LAST_CHUNK = "0\r\n\r\n".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }
}

