/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.file.client;

import com.idoox.transport.file.client.FileRequest;
import com.idoox.transport.file.client.FileResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.util.RuntimeWrappedException;

public class FileConnection
implements ClientConnection {
    private URI endpoint;
    private TransportMethod method;
    private OutputMessage request;
    private InputMessage response;
    private boolean inInited = false;
    private boolean outInited = false;

    FileConnection(URI uri, TransportMethod method) throws IOException {
        if (method == TransportMethod.DELETE) {
            this.inInited = true;
            this.outInited = true;
            File file = new File(uri.getLocation());
            if (!file.delete()) {
                throw new IOException("File " + uri.getLocation() + " can't be deleted");
            }
        }
        this.endpoint = uri;
        this.method = method;
    }

    private void init() throws IOException {
        if (this.method == TransportMethod.POST) {
            if (!this.outInited) {
                this.outInited = true;
                this.request = new FileRequest(this.endpoint.getPath() + ".out");
            }
            if (!this.inInited) {
                this.inInited = true;
                try {
                    this.response = new FileResponse(this.endpoint.getPath() + ".in");
                }
                catch (FileNotFoundException e) {
                    this.response = null;
                }
            }
        } else if (this.method == TransportMethod.GET) {
            if (!this.outInited) {
                this.outInited = true;
                this.request = null;
            }
            if (!this.inInited) {
                this.inInited = true;
                this.response = new FileResponse(this.endpoint.getPath());
            }
        } else if (this.method == TransportMethod.PUT) {
            if (!this.outInited) {
                this.outInited = true;
                this.request = new FileRequest(this.endpoint.getPath());
            }
            if (!this.inInited) {
                this.inInited = true;
                this.response = null;
            }
        }
    }

    public void setTimeout(int time) {
    }

    public InputMessage getInputMessage() {
        try {
            if (!this.inInited) {
                this.init();
            }
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
        return this.response;
    }

    public void setInputMessage(InputMessage message) {
        this.inInited = true;
        this.response = message;
    }

    public OutputMessage getOutputMessage() {
        try {
            if (!this.outInited) {
                this.init();
            }
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
        return this.request;
    }

    public void setOutputMessage(OutputMessage message) {
        this.outInited = true;
        this.request = message;
    }

    public TransportMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.endpoint;
    }
}

