/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.dime;

import com.idoox.transport.util.Headers;
import java.io.IOException;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.OutputMessageWrapper;

public class DIMEOutputMessage
extends OutputMessageWrapper {
    private boolean dimeMessage = false;
    private String type;
    private String id;
    private boolean headersToWrite = false;
    private static final int MAX_REC_LENGTH = 4096;
    private byte[] record;
    private int recLength = 0;
    private static final int MIN_HEADER_LENGTH = 12;
    private int headerLength = 0;
    private static final byte[] EMPTY_RECORD_HEADER = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] ZERO_PADDING = new byte[]{0, 0, 0, 0};

    public DIMEOutputMessage(OutputMessage message) {
        super(message);
    }

    public void setContentType(String type) {
        if (this.dimeMessage) {
            this.type = type;
            this.headersToWrite = true;
        } else {
            super.setContentType(type);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.dimeMessage) {
            this.setStringHeader(name, String.valueOf(value));
        } else {
            super.setIntHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.dimeMessage) {
            this.setStringHeader(name, Headers.createDate(value));
        } else {
            super.setDateHeader(name, value);
        }
    }

    public void setStringHeader(String name, String value) {
        if (this.dimeMessage) {
            if ("content-id".equalsIgnoreCase(name) || "content-location".equalsIgnoreCase(name) && this.id == null) {
                if (value.indexOf(58) < 0 && value.indexOf(47) < 0) {
                    value = "cid:" + value;
                }
                this.id = value;
                this.headersToWrite = true;
            } else if ("content-type".equalsIgnoreCase(name)) {
                this.type = value;
                this.headersToWrite = true;
            }
        } else {
            super.setStringHeader(name, value);
        }
    }

    public void setMultipartType(String type) throws IOException {
        this.dimeMessage = "application/dime".equals(type);
        if (this.dimeMessage) {
            if (this.record == null) {
                this.record = new byte[4096];
                this.initRecord();
            }
            this.record[0] = (byte)(this.record[0] | 4);
            super.setContentType(type);
        } else {
            super.setMultipartType(type);
        }
    }

    public void nextPart() throws IOException {
        if (this.dimeMessage) {
            if (this.headersToWrite) {
                this.storeHeaders();
            }
            this.record[0] = (byte)(this.record[0] & 0xFFFFFFFE);
            this.writeRecord();
        }
        super.nextPart();
    }

    public void write(byte[] b) throws IOException {
        if (this.dimeMessage) {
            this.write(b, 0, b.length);
        } else {
            super.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.dimeMessage) {
            if (this.headersToWrite && len > 0) {
                this.storeHeaders();
            }
            while (len > 0) {
                int toWrite;
                if (this.recLength == 4096) {
                    this.writeChunk();
                }
                if ((toWrite = len) > 4096 - this.recLength) {
                    toWrite = 4096 - this.recLength;
                }
                System.arraycopy(b, off, this.record, this.recLength, toWrite);
                len -= toWrite;
                off += toWrite;
                this.recLength += toWrite;
            }
        } else {
            super.write(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        if (this.dimeMessage) {
            if (this.headersToWrite) {
                this.storeHeaders();
            }
            if (this.recLength == 4096) {
                this.writeChunk();
            }
            this.record[this.recLength++] = (byte)(b & 0xFF);
        } else {
            super.write(b);
        }
    }

    public void close() throws IOException {
        if (this.dimeMessage) {
            if (this.headersToWrite) {
                this.storeHeaders();
            }
            this.record[0] = (byte)(this.record[0] | 2);
            this.record[0] = (byte)(this.record[0] & 0xFFFFFFFE);
            this.writeRecord();
            this.getWrappedStream().close();
            this.dimeMessage = false;
        } else {
            super.close();
        }
    }

    private void storeHeaders() {
        this.store16(this.record, 2, 0);
        int length = this.storeString32(this.record, this.recLength, this.id);
        this.store16(this.record, 4, length);
        this.recLength += DIMEOutputMessage.padding32(length);
        this.id = null;
        length = 0;
        if (this.type == null || this.type.length() == 0) {
            this.record[1] = 64;
        } else {
            int firstSlash;
            length = this.storeString32(this.record, this.recLength, this.type);
            this.recLength += DIMEOutputMessage.padding32(length);
            this.record[1] = this.type.indexOf(58) >= 0 ? 32 : ((firstSlash = this.type.indexOf(47)) > 0 && this.type.lastIndexOf(47) == firstSlash ? 16 : 48);
        }
        this.store16(this.record, 6, length);
        this.type = null;
        this.headerLength = this.recLength;
        this.headersToWrite = false;
    }

    private void writeChunk() throws IOException {
        this.record[0] = (byte)(this.record[0] | 1);
        this.writeRecord();
        this.record[0] = (byte)(this.record[0] | 1);
    }

    private void writeRecord() throws IOException {
        this.store32(this.record, 8, this.recLength - this.headerLength);
        int recLength32 = DIMEOutputMessage.padding32(this.recLength);
        if (recLength32 > this.recLength) {
            System.arraycopy(ZERO_PADDING, 0, this.record, this.recLength, recLength32 - this.recLength);
        }
        super.write(this.record, 0, recLength32);
        this.initRecord();
    }

    private void initRecord() {
        this.recLength = 12;
        this.headerLength = 12;
        System.arraycopy(EMPTY_RECORD_HEADER, 0, this.record, 0, 12);
        this.record[0] = 8;
        this.record[1] = 0;
    }

    private void store32(byte[] dst, int offset, int data) {
        dst[offset++] = (byte)(data >>> 24);
        dst[offset++] = (byte)(data >>> 16 & 0xFF);
        dst[offset++] = (byte)(data >>> 8 & 0xFF);
        dst[offset++] = (byte)(data & 0xFF);
    }

    private void store16(byte[] dst, int offset, int data) {
        dst[offset++] = (byte)(data >>> 8 & 0xFF);
        dst[offset++] = (byte)(data & 0xFF);
    }

    private int storeString32(byte[] dst, int offset, String data) {
        int length = 0;
        if (data != null && data.length() > 0) {
            byte[] bytes = data.getBytes();
            length = bytes.length;
            System.arraycopy(bytes, 0, dst, offset, length);
            int length32 = DIMEOutputMessage.padding32(length);
            if (length32 > length) {
                System.arraycopy(ZERO_PADDING, 0, dst, offset + length, length32 - length);
            }
        }
        return length;
    }

    private static int padding32(int length) {
        return (length - 1 | 3) + 1;
    }
}

