/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.TransportStartException;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.server.ConnectionHandler;

public class ClientServerTransport
implements Transport {
    protected Transport client = null;
    protected Transport server = null;
    private Set methods;

    protected Transport getClient() {
        return this.client;
    }

    protected Transport getServer() {
        return this.server;
    }

    public void load(Configurable c) {
        if (this.getClient() != null) {
            this.getClient().load(c);
        }
        if (this.getServer() != null) {
            this.getServer().load(c);
        }
    }

    public void destroy() {
        if (this.getClient() != null) {
            this.getClient().destroy();
        }
        if (this.getServer() != null) {
            this.getServer().destroy();
        }
    }

    public void start(URI endpoint) throws TransportStartException {
        if (this.getServer() != null) {
            this.getServer().start(endpoint);
        }
    }

    public void stop() {
        if (this.getServer() != null) {
            this.getServer().stop();
        }
    }

    public boolean isStarted() {
        if (this.getServer() != null) {
            return this.getServer().isStarted();
        }
        return false;
    }

    public ConnectionHandler setHandler(ConnectionHandler handler) {
        if (this.getServer() != null) {
            return this.getServer().setHandler(handler);
        }
        return null;
    }

    public ClientConnection newConnection(URI uri, TransportMethod method, Map properties) throws IOException {
        if (this.getClient() != null) {
            return this.getClient().newConnection(uri, method, properties);
        }
        return null;
    }

    public Set getMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        Set clientMethods = Collections.EMPTY_SET;
        if (this.getClient() != null) {
            clientMethods = this.getClient().getMethods();
        }
        Set serverMethods = Collections.EMPTY_SET;
        if (this.getServer() != null) {
            serverMethods = this.getServer().getMethods();
        }
        this.methods = new HashSet();
        Iterator i = clientMethods.iterator();
        while (i.hasNext()) {
            TransportMethod method = (TransportMethod)i.next();
            if (!serverMethods.contains(method)) continue;
            this.methods.add(method);
        }
        return this.methods;
    }

    public int getType() {
        int type = 0;
        if (this.getClient() != null) {
            type |= 2;
        }
        if (this.getServer() != null) {
            type |= 1;
        }
        return type;
    }

    public String getLocalPath(URI endpoint) {
        if (this.getServer() != null) {
            return this.getServer().getLocalPath(endpoint);
        }
        return null;
    }

    public Endpoint[] getAbsolutePath(String path) throws MalformedURLException {
        if (this.getServer() != null) {
            return this.getServer().getAbsolutePath(path);
        }
        return null;
    }
}

