/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap.encoding;

import com.idoox.util.xml.DOM2XMLWriter;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.MessagePart;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.w3c.dom.Element;

public class SOAPEncodingTokenWriter
implements EncodingTokenWriter {
    Message message;
    TokenWriter currentWriter;
    int currentDepth;
    String[] namespaceMap = null;
    int namespaceMapUsed = 0;
    protected String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    protected String XML_NULL = "nil";
    private StringBuffer tsb = new StringBuffer();

    public void setEncoding(String encodingURI) throws NoSuchEncodingException {
        if (encodingURI != "http://schemas.xmlsoap.org/soap/encoding/") {
            throw new UnsupportedOperationException("encodingTransitions are not implemented");
        }
    }

    public void setMessage(Message message) throws MessageCreatingException {
        try {
            this.message = message;
            message.setElementAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"), "http://schemas.xmlsoap.org/soap/encoding/", 2);
            this.currentDepth = 0;
            MessagePart bodyPart = message.createBody();
            this.currentWriter = bodyPart.getContentTokenWriter();
        }
        catch (Exception e) {
            throw new MessageCreatingException(e);
        }
    }

    public void flush() throws IOException {
    }

    public void setTokenWriter(TokenWriter writer) {
        this.currentWriter = writer;
        this.currentDepth = 0;
    }

    public void writePrimitive(QName name, QName type, String value, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (type != null && type.getLocalPart().length() > 0) {
                this.tsb.delete(0, this.tsb.length());
                this.tsb.append(this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()));
                this.tsb.append(':');
                this.tsb.append(type.getLocalPart());
                this.currentWriter.writeAttribute(this.XSI_NS, "type", this.tsb.toString());
            }
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            if (arrayPos != null) {
                this.writeArrayPos(arrayPos);
            }
            if (value != null) {
                this.currentWriter.writeContent(value);
            } else {
                this.currentWriter.writeAttribute(this.XSI_NS, this.XML_NULL, "1");
            }
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeQName(QName name, QName type, QName value, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (type != null && type.getLocalPart().length() > 0) {
                this.currentWriter.writeAttribute(this.XSI_NS, "type", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart());
            }
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            if (value != null) {
                String prefix;
                String nsURI = value.getNamespaceURI();
                if (nsURI == null || nsURI.length() == 0) {
                    prefix = "";
                    this.currentWriter.getPrefixForNamespace("");
                } else {
                    prefix = this.currentWriter.getPrefixForNamespace(nsURI) + ":";
                }
                this.currentWriter.writeContent(prefix + value.getLocalPart());
            } else {
                this.currentWriter.writeAttribute(this.XSI_NS, this.XML_NULL, "1");
            }
            if (arrayPos != null) {
                this.writeArrayPos(arrayPos);
            }
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeNil(QName name, int[] arrayPos) throws MessageCreatingException {
        try {
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            this.currentWriter.writeAttribute(this.XSI_NS, this.XML_NULL, "1");
            if (arrayPos != null) {
                this.writeArrayPos(arrayPos);
            }
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeStructureStart(QName name, QName type, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (type != null && type.getLocalPart().length() > 0) {
                this.currentWriter.writeAttribute(this.XSI_NS, "type", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart());
            }
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            if (arrayPos != null) {
                this.writeArrayPos(arrayPos);
            }
            ++this.currentDepth;
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeStructureEnd() throws MessageCreatingException {
        try {
            --this.currentDepth;
            if (this.currentDepth >= 0) {
                this.currentWriter.leave();
            } else if (this.currentDepth < 0) {
                throw new MessageCreatingException("writeStructureEnd has been called before writeStructureStart");
            }
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeArrayStart(QName name, QName type, int[] dimensions, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (type == null || type.getLocalPart().length() <= 0) {
                throw new MessageCreatingException("Array has to have a type");
            }
            this.currentWriter.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart() + this.formatDimensions(dimensions));
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            if (arrayPos != null) {
                this.writeArrayPos(arrayPos);
            }
            ++this.currentDepth;
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeArrayEnd() throws MessageCreatingException {
        try {
            --this.currentDepth;
            if (this.currentDepth >= 0) {
                this.currentWriter.leave();
            } else if (this.currentDepth < 0) {
                throw new MessageCreatingException("writeArrayEnd has been called before writeArrayStart");
            }
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeReference(QName name, int[] arrayPos, String idref) throws MessageCreatingException {
        this.writeSoapReference(null, "href", name, arrayPos, idref);
    }

    public void writeSoapReference(String referenceNamespaceURI, String referenceLocalName, QName name, int[] arrayPos, String idref) throws MessageCreatingException {
        try {
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            this.currentWriter.writeAttribute(referenceNamespaceURI, referenceLocalName, idref);
            if (arrayPos != null) {
                this.writeArrayPos(arrayPos);
            }
            if (this.currentDepth >= 0) {
                this.currentWriter.leave();
            }
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeElement(Element element) throws MessageCreatingException {
        try {
            String localName = element.getLocalName();
            if (localName != null) {
                this.currentWriter.enter(element.getNamespaceURI(), localName);
            } else {
                this.currentWriter.enter(null, element.getNodeName());
            }
            DOM2XMLWriter.writeElementContent(element, this.currentWriter);
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void setPrefixForNamespace(String prefix, String namespaceURI) throws MessageCreatingException {
        try {
            if (this.currentWriter == null) {
                if (this.namespaceMap == null) {
                    this.namespaceMap = new String[20];
                }
                if (this.namespaceMap.length == this.namespaceMapUsed) {
                    int s = this.namespaceMap.length;
                    int ns = s + 20;
                    String[] newArr = new String[ns];
                    System.arraycopy(this.namespaceMap, 0, newArr, 0, s);
                    this.namespaceMap = newArr;
                }
                this.namespaceMap[this.namespaceMapUsed++] = prefix;
                this.namespaceMap[this.namespaceMapUsed++] = namespaceURI;
                return;
            }
            this.currentWriter.setPrefixForNamespace(prefix, namespaceURI);
        }
        catch (Exception e) {
            throw new MessageCreatingException(e);
        }
    }

    private String formatDimensions(int[] dims) {
        StringBuffer d = new StringBuffer();
        d.append('[');
        int i = 0;
        while (i < dims.length) {
            if (i > 0) {
                d.append(',');
            }
            d.append(dims[i]);
            ++i;
        }
        d.append(']');
        return d.toString();
    }

    private void writeArrayPos(int[] arrayPos) throws IOException {
        this.currentWriter.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "position", this.formatDimensions(arrayPos));
    }

    public void init(Configurable conf) {
    }
}

