/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap.encoding;

import com.idoox.Namespaces;
import com.idoox.wasp.Constants;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.Context;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessagePart;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingToken;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAP12EncodingTokenizer
implements EncodingTokenizer {
    protected Message message;
    protected Tokenizer currentTokenizer;
    protected Token token = new Token();
    protected int nestingDepth;
    protected EncodingTokenizer subEncodingTokenizer;
    protected String encodingId;
    protected String subEncodingStyle;
    protected String soapStructureName;
    protected String soapStructureNamespace;
    protected QName soapStructureType;
    protected int[] arraySizes;
    protected int arraySizesUsed;
    protected int arraySizesSize;
    protected String referenceID;
    protected boolean referenceIDisDIME;
    protected String ID;
    protected String content;
    protected int currentToken;
    private boolean first;
    private String currentQNamePrefix;
    private String currentQNameNamespace;
    private boolean alreadyOnNextToken;
    protected EncodingRepository encodingRepository = (EncodingRepository)Context.getInstance(class$com$idoox$xmlrpc$encoding$EncodingRepository == null ? (class$com$idoox$xmlrpc$encoding$EncodingRepository = SOAP12EncodingTokenizer.class$("com.idoox.xmlrpc.encoding.EncodingRepository")) : class$com$idoox$xmlrpc$encoding$EncodingRepository);
    static /* synthetic */ Class class$com$idoox$xmlrpc$encoding$EncodingRepository;

    public void setInputMessage(Message message, String encodingId) throws MessageProcessingException {
        try {
            this.message = message;
            MessagePart bodyPart = message.getBody();
            Tokenizer tokenizer = bodyPart.getTokenizer();
            while (tokenizer.next() == 4) {
            }
            this.setInput(tokenizer, encodingId);
            this.nestingDepth = 1;
        }
        catch (Exception e) {
            throw new MessageProcessingException(e);
        }
    }

    public void setInput(Tokenizer parser, String encodingId) throws MessageProcessingException {
        try {
            this.alreadyOnNextToken = true;
            this.encodingId = encodingId;
            this.currentTokenizer = parser;
            this.nestingDepth = 0;
            this.first = true;
            this.subEncodingTokenizer = null;
            this.subEncodingStyle = null;
            this.currentTokenizer.readToken(this.token);
            if (this.token.getType() != 2) {
                throw new MessageProcessingException("Bad token type");
            }
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException(e);
        }
        catch (IOException e) {
            throw new MessageProcessingException(e);
        }
    }

    public int nextToken() throws MessageProcessingException {
        this.next();
        return this.getCurrentToken();
    }

    public int next() throws MessageProcessingException {
        this.soapStructureType = Constants.nullQName;
        this.currentQNamePrefix = null;
        this.ID = null;
        try {
            if (!this.first) {
                if (!this.alreadyOnNextToken) {
                    this.getCurrentToken();
                }
                if (this.nestingDepth == 0) {
                    if (this.currentToken == 0) {
                        throw new IllegalStateException("Attempt to read beyond end of document");
                    }
                    this.currentToken = 0;
                    return 0;
                }
            } else {
                this.first = false;
            }
            if (this.subEncodingTokenizer != null) {
                throw new UnsupportedOperationException("todo");
            }
            this.alreadyOnNextToken = false;
            if (this.token.getType() == 3) {
                --this.nestingDepth;
                this.goToNextToken();
                this.currentToken = 2;
                return 2;
            }
            this.ID = this.token.getAttributeValue(null, "id");
            String encodingStyle = this.token.getAttributeValue(Namespaces.SOAP12_ENV_NS, "encodingStyle");
            if (encodingStyle != null && !Namespaces.SOAP12_ENC_NS.equals(encodingStyle)) {
                if (this.encodingRepository == null) {
                    throw new RuntimeException("No repository when trying to get encoding tokenizer for " + encodingStyle);
                }
                this.subEncodingTokenizer = this.encodingRepository.getEncodingTokenizer(this.encodingId, encodingStyle);
                this.subEncodingStyle = encodingStyle;
                this.subEncodingTokenizer.setInput(this.currentTokenizer, this.encodingId);
                this.currentToken = this.subEncodingTokenizer.next();
                return this.currentToken;
            }
            this.soapStructureName = this.token.getLocalName();
            if (this.soapStructureName == null) {
                this.soapStructureName = "";
            }
            this.soapStructureNamespace = this.token.getNamespace();
            if (this.soapStructureNamespace == null) {
                this.soapStructureNamespace = "";
            }
            String itemType = this.getSoapEncAttribute("itemType");
            String arraySize = this.getSoapEncAttribute("arraySize");
            if (itemType != null || arraySize != null) {
                this.parseArraySize(arraySize);
                this.soapStructureType = itemType != null ? this.convertToQName(itemType) : null;
                ++this.nestingDepth;
                this.currentToken = 3;
                return 3;
            }
            this.referenceID = this.token.getAttributeValue(null, "ref");
            this.referenceIDisDIME = false;
            if (this.referenceID == null) {
                this.referenceID = this.token.getAttributeValue("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location");
                if (this.referenceID != null) {
                    this.referenceIDisDIME = true;
                }
            }
            if (this.referenceID != null) {
                byte tokenType = this.currentTokenizer.next();
                if (tokenType != 3) {
                    throw new MessageProcessingException("Reference must not contain content");
                }
                this.goToNextToken();
                this.currentToken = 5;
                return 5;
            }
            String nil2001 = this.token.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            String null2001 = this.token.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "null");
            String null2000 = this.token.getAttributeValue("http://www.w3.org/2000/10/XMLSchema-instance", "null");
            String null1999 = this.token.getAttributeValue("http://www.w3.org/1999/XMLSchema-instance", "null");
            if (nil2001 != null && ("1".equals(nil2001) || "true".equals(nil2001)) || null2001 != null && ("1".equals(null2001) || "true".equals(null2001)) || null2000 != null && ("1".equals(null2000) || "true".equals(null2000)) || null1999 != null && ("1".equals(null1999) || "true".equals(null1999))) {
                byte tokenType = this.currentTokenizer.next();
                if (tokenType != 3) {
                    throw new MessageProcessingException("Null must not contain content");
                }
                this.goToNextToken();
                this.currentToken = 6;
                return 6;
            }
            String xsiType = this.token.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (xsiType == null && (xsiType = this.token.getAttributeValue("http://www.w3.org/2000/10/XMLSchema-instance", "type")) == null) {
                xsiType = this.token.getAttributeValue("http://www.w3.org/1999/XMLSchema-instance", "type");
            }
            if (xsiType != null) {
                this.soapStructureType = this.convertToQName(xsiType);
            } else if ("http://www.w3.org/2001/XMLSchema".equals(this.soapStructureNamespace)) {
                this.soapStructureType = new QName(this.soapStructureNamespace, this.soapStructureName);
                this.soapStructureName = null;
                this.soapStructureNamespace = null;
            } else {
                this.soapStructureType = Constants.nullQName;
            }
            this.currentToken = 7;
            return 7;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException(e);
        }
        catch (IOException e) {
            throw new MessageProcessingException(e);
        }
        catch (NoSuchEncodingException e) {
            throw new MessageProcessingException(e);
        }
    }

    private void goToNextToken() throws MessageProcessingException {
        try {
            byte tokenType;
            while ((tokenType = this.currentTokenizer.next()) == 4) {
            }
            if (tokenType != 1) {
                this.currentTokenizer.readToken(this.token);
            } else {
                this.token.type = 1;
            }
            this.alreadyOnNextToken = true;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException(e);
        }
        catch (IOException e) {
            throw new MessageProcessingException(e);
        }
    }

    private void processUnknownEncodingToken() throws MessageProcessingException {
        try {
            byte tokenType = this.currentTokenizer.next();
            if (tokenType == 4) {
                this.currentQNamePrefix = "";
                this.currentQNameNamespace = this.currentTokenizer.getNamespaceForPrefix(null);
                this.content = this.currentTokenizer.readContent();
                int colonPos = -1;
                while (true) {
                    if (colonPos < 0 && (colonPos = this.content.indexOf(58)) > 0) {
                        this.currentQNamePrefix = this.content.substring(0, colonPos);
                        this.currentQNameNamespace = this.currentTokenizer.getNamespaceForPrefix(this.currentQNamePrefix);
                    }
                    if ((tokenType = this.currentTokenizer.next()) != 4) break;
                    this.content = this.content + this.currentTokenizer.readContent();
                }
                if (tokenType == 3) {
                    this.goToNextToken();
                    this.currentToken = 4;
                    return;
                }
            }
            this.currentTokenizer.readToken(this.token);
            ++this.nestingDepth;
            this.currentToken = 1;
            this.alreadyOnNextToken = true;
            return;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException(e);
        }
        catch (IOException e) {
            throw new MessageProcessingException(e);
        }
    }

    public Element getElementTokenValue(Document doc) throws MessageProcessingException {
        this.currentToken = 1;
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.nextAsElement(doc);
        }
        try {
            Element ret = this.currentTokenizer.getDOMRepresentation(doc);
            return ret;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException(e);
        }
    }

    public Element nextAsElement(Document doc) throws MessageProcessingException {
        this.next();
        this.currentToken = 1;
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.nextAsElement(doc);
        }
        try {
            return this.currentTokenizer.getDOMRepresentation(doc);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException(e);
        }
    }

    public int getCurrentToken() throws MessageProcessingException {
        if (this.currentToken == 7) {
            this.processUnknownEncodingToken();
        }
        if (!this.alreadyOnNextToken) {
            this.goToNextToken();
        }
        return this.currentToken;
    }

    public String getTokenName() throws MessageProcessingException {
        if (this.currentToken != 7 && this.currentToken != 1 && this.currentToken != 3 && this.currentToken != 5 && this.currentToken != 4 && this.currentToken != 6) {
            throw new IllegalStateException("Bad state: " + EncodingToken.tokenNames[this.currentToken]);
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getTokenName();
        }
        return this.soapStructureName;
    }

    public String getTokenNamespaceURI() throws MessageProcessingException {
        if (this.currentToken != 7 && this.currentToken != 1 && this.currentToken != 3 && this.currentToken != 5 && this.currentToken != 4 && this.currentToken != 6) {
            throw new IllegalStateException("Bad state");
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getTokenNamespaceURI();
        }
        return this.soapStructureNamespace;
    }

    public String getTokenTypeName() throws MessageProcessingException {
        if (this.currentToken != 7 && this.currentToken != 1 && this.currentToken != 3 && this.currentToken != 5 && this.currentToken != 4 && this.currentToken != 6) {
            throw new IllegalStateException("Bad state");
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getTokenTypeName();
        }
        if (this.soapStructureType != Constants.nullQName) {
            return this.soapStructureType.getLocalPart();
        }
        return null;
    }

    public String getTokenTypeNamespaceURI() throws MessageProcessingException {
        if (this.currentToken != 7 && this.currentToken != 1 && this.currentToken != 3 && this.currentToken != 5 && this.currentToken != 4 && this.currentToken != 6) {
            throw new IllegalStateException("Bad state");
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getTokenTypeNamespaceURI();
        }
        if (this.soapStructureType != Constants.nullQName) {
            return this.soapStructureType.getNamespaceURI();
        }
        return null;
    }

    public int[] getArrayDimensions() throws MessageProcessingException {
        if (this.currentToken != 3) {
            throw new IllegalStateException("Bad state");
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getArrayDimensions();
        }
        int[] arr = new int[this.arraySizesUsed];
        System.arraycopy(this.arraySizes, 0, arr, 0, this.arraySizesUsed);
        return arr;
    }

    public int[] getArrayOffset() throws MessageProcessingException {
        if (this.currentToken != 3) {
            throw new IllegalStateException("Bad state : " + EncodingToken.tokenNames[this.currentToken]);
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getArrayOffset();
        }
        return new int[this.arraySizesUsed];
    }

    public int[] getArrayPosition(int expectedDimensions) throws MessageProcessingException {
        if (this.currentToken != 7 && this.currentToken != 1 && this.currentToken != 3 && this.currentToken != 5 && this.currentToken != 4 && this.currentToken != 6) {
            throw new IllegalStateException("Bad state " + EncodingToken.tokenNames[this.currentToken]);
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getArrayPosition(expectedDimensions);
        }
        return null;
    }

    public String getPrimitiveTokenValue() throws MessageProcessingException {
        if (this.currentToken == 7) {
            this.processUnknownEncodingToken();
        }
        if (this.currentToken != 4) {
            throw new IllegalStateException("Bad state");
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getPrimitiveTokenValue();
        }
        return this.content;
    }

    public String getID() throws MessageProcessingException {
        if (this.currentToken != 7 && this.currentToken != 1 && this.currentToken != 3 && this.currentToken != 5 && this.currentToken != 4 && this.currentToken != 6) {
            throw new IllegalStateException("Bad state");
        }
        return this.ID;
    }

    public String getReference() throws MessageProcessingException {
        if (this.currentToken != 5) {
            throw new IllegalStateException("Bad state");
        }
        if (this.subEncodingTokenizer != null) {
            return this.subEncodingTokenizer.getReference();
        }
        return this.referenceIDisDIME ? this.referenceID : "#" + this.referenceID;
    }

    public final QName convertToQName(String qname) {
        int localOffset = qname.indexOf(58);
        String prefix = null;
        String localName = null;
        if (localOffset >= 0) {
            prefix = qname.substring(0, localOffset);
            localName = qname.substring(localOffset + 1);
        } else {
            prefix = "";
            localName = qname;
        }
        if (prefix != null && prefix.equals(this.currentQNamePrefix)) {
            return new QName(this.currentQNameNamespace, localName);
        }
        return new QName(this.currentTokenizer.getNamespaceForPrefix(prefix), localName);
    }

    protected final void parseArraySize(String size) throws MessageProcessingException {
        StringTokenizer st = new StringTokenizer(size);
        this.arraySizesUsed = st.countTokens();
        if (this.arraySizesUsed > 0) {
            this.ensureArraySizeNoCopy(this.arraySizesUsed);
            try {
                int i = 0;
                while (i < this.arraySizesUsed) {
                    String token = st.nextToken();
                    if ("*".equals(token)) {
                        if (i != 0) {
                            throw new MessageProcessingException("Invalid array size: \"" + size + "\"");
                        }
                        this.arraySizes[i] = -1;
                    } else {
                        this.arraySizes[i] = Integer.parseInt(token);
                        if (this.arraySizes[i] < 0) {
                            throw new MessageProcessingException("Invalid array size: \"" + size + "\"");
                        }
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                throw new MessageProcessingException("Invalid array size: \"" + size + "\"");
            }
        } else {
            this.arraySizesUsed = 1;
            this.ensureArraySizeNoCopy(this.arraySizesUsed);
            this.arraySizes[0] = -1;
        }
    }

    protected final void ensureArraySizeNoCopy(int dims) {
        if (dims > this.arraySizesSize) {
            this.arraySizesSize = dims + 5;
            this.arraySizes = new int[this.arraySizesSize];
        }
    }

    protected final String getSoapEncAttribute(String attr) {
        int s = this.token.getAttributeCount();
        int i = 0;
        while (i < s) {
            if (this.token.getAttributeLocalName(i).equals(attr) && Namespaces.SOAP12_ENC_NS.equals(this.token.getAttributeNamespace(i))) {
                return this.token.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    public void init(Configurable conf) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

