/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap.encoding;

import com.idoox.Namespaces;
import com.idoox.util.xml.DOM2XMLWriter;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.w3c.dom.Element;

public class SOAP12EncodingTokenWriter
implements EncodingTokenWriter {
    Message message;
    TokenWriter currentWriter;
    int currentDepth;
    String[] namespaceMap = null;
    int namespaceMapUsed = 0;
    int[][] arraySizesStack = null;
    int[] arrayPositionStack = null;
    protected static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String XML_NULL = "nil";
    public static final QName NIL_ARRAY_MEMBER_QNAME = new QName(null, "x");

    public void setEncoding(String encodingURI) throws NoSuchEncodingException {
        if (encodingURI != Namespaces.SOAP12_ENC_NS) {
            throw new UnsupportedOperationException("encodingTransitions are not implemented");
        }
    }

    public void setMessage(Message message) throws MessageCreatingException {
        try {
            this.message = message;
            this.currentDepth = 0;
            this.ensureArrayStacksSize(this.currentDepth);
            this.arrayPositionStack[this.currentDepth] = 0;
            this.arraySizesStack[this.currentDepth] = null;
            this.currentWriter = message.createBody().getContentTokenWriter();
        }
        catch (Exception e) {
            throw new MessageCreatingException(e);
        }
    }

    public void flush() throws IOException {
    }

    public void setTokenWriter(TokenWriter writer) {
        this.currentWriter = writer;
        this.currentDepth = 0;
        this.ensureArrayStacksSize(this.currentDepth);
        this.arrayPositionStack[this.currentDepth] = 0;
        this.arraySizesStack[this.currentDepth] = null;
    }

    public void writePrimitive(QName name, QName type, String value, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.writeArrayPos(arrayPos);
            this.ensureArrayStacksSize(this.currentDepth);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            if (type != null && type.getLocalPart().length() > 0) {
                this.currentWriter.writeAttribute(XSI_NS, "type", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart());
            }
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            if (value != null) {
                this.currentWriter.writeContent(value);
            } else {
                this.currentWriter.writeAttribute(XSI_NS, XML_NULL, "1");
            }
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeQName(QName name, QName type, QName value, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.writeArrayPos(arrayPos);
            this.ensureArrayStacksSize(this.currentDepth);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            if (type != null && type.getLocalPart().length() > 0) {
                this.currentWriter.writeAttribute(XSI_NS, "type", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart());
            }
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            if (value != null) {
                String prefix;
                String nsURI = value.getNamespaceURI();
                if (nsURI == null || nsURI.length() == 0) {
                    prefix = "";
                    this.currentWriter.getPrefixForNamespace("");
                } else {
                    prefix = this.currentWriter.getPrefixForNamespace(nsURI) + ":";
                }
                this.currentWriter.writeContent(prefix + value.getLocalPart());
            } else {
                this.currentWriter.writeAttribute(XSI_NS, XML_NULL, "1");
            }
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeNil(QName name, int[] arrayPos) throws MessageCreatingException {
        try {
            this.writeArrayPos(arrayPos);
            this.ensureArrayStacksSize(this.currentDepth);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            this.currentWriter.writeAttribute(XSI_NS, XML_NULL, "1");
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeStructureStart(QName name, QName type, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.writeArrayPos(arrayPos);
            this.ensureArrayStacksSize(this.currentDepth + 1);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            if (type != null && type.getLocalPart().length() > 0) {
                this.currentWriter.writeAttribute(XSI_NS, "type", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart());
            }
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            ++this.currentDepth;
            this.arrayPositionStack[this.currentDepth] = 0;
            this.arraySizesStack[this.currentDepth] = null;
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeStructureEnd() throws MessageCreatingException {
        if (this.currentDepth <= 0) {
            throw new MessageCreatingException("writeStructureEnd has been called before writeStructureStart");
        }
        this.ensureArrayStacksSize(this.currentDepth);
        this.arrayPositionStack[this.currentDepth] = 0;
        this.arraySizesStack[this.currentDepth] = null;
        --this.currentDepth;
        try {
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeArrayStart(QName name, QName type, int[] dimensions, int[] arrayPos, String id) throws MessageCreatingException {
        try {
            this.writeArrayPos(arrayPos);
            this.ensureArrayStacksSize(this.currentDepth + 1);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            if (type != null) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENC_NS, "itemType", this.currentWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart());
            }
            this.currentWriter.writeAttribute(Namespaces.SOAP12_ENC_NS, "arraySize", this.formatDimensions(dimensions));
            if (id != null) {
                this.currentWriter.writeAttribute(null, "id", id);
            }
            ++this.currentDepth;
            this.arrayPositionStack[this.currentDepth] = 0;
            this.arraySizesStack[this.currentDepth] = dimensions;
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeArrayEnd() throws MessageCreatingException {
        if (this.currentDepth <= 0) {
            throw new MessageCreatingException("writeArrayEnd has been called before writeArrayStart");
        }
        this.ensureArrayStacksSize(this.currentDepth);
        this.writeRemainingArrayMembers();
        this.arrayPositionStack[this.currentDepth] = 0;
        this.arraySizesStack[this.currentDepth] = null;
        --this.currentDepth;
        try {
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeReference(QName name, int[] arrayPos, String idref) throws MessageCreatingException {
        this.writeSoapReference(null, "ref", name, arrayPos, idref);
    }

    public void writeSoapReference(String referenceNamespaceURI, String referenceLocalName, QName name, int[] arrayPos, String idref) throws MessageCreatingException {
        try {
            this.writeArrayPos(arrayPos);
            if (idref.charAt(0) != '#') {
                throw new MessageCreatingException("In SOAP 1.2 Encoding only IDREF references are allowed (invalid reference: \"" + idref + "\")");
            }
            this.ensureArrayStacksSize(this.currentDepth);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            this.currentWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            this.currentWriter.writeAttribute(referenceNamespaceURI, referenceLocalName, idref.substring(1));
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void writeElement(Element element) throws MessageCreatingException {
        try {
            this.ensureArrayStacksSize(this.currentDepth);
            int n = this.currentDepth;
            this.arrayPositionStack[n] = this.arrayPositionStack[n] + 1;
            String localName = element.getLocalName();
            if (localName != null) {
                this.currentWriter.enter(element.getNamespaceURI(), localName);
            } else {
                this.currentWriter.enter(null, element.getNodeName());
            }
            if (this.currentDepth == 0) {
                this.currentWriter.writeAttribute(Namespaces.SOAP12_ENV_NS, "encodingStyle", Namespaces.SOAP12_ENC_NS);
            }
            DOM2XMLWriter.writeElementContent(element, this.currentWriter);
            this.currentWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException(e);
        }
    }

    public void setPrefixForNamespace(String prefix, String namespaceURI) throws MessageCreatingException {
        try {
            if (this.currentWriter == null) {
                if (this.namespaceMap == null) {
                    this.namespaceMap = new String[20];
                }
                if (this.namespaceMap.length == this.namespaceMapUsed) {
                    int s = this.namespaceMap.length;
                    int ns = s + 20;
                    String[] newArr = new String[ns];
                    System.arraycopy(this.namespaceMap, 0, newArr, 0, s);
                    this.namespaceMap = newArr;
                }
                this.namespaceMap[this.namespaceMapUsed++] = prefix;
                this.namespaceMap[this.namespaceMapUsed++] = namespaceURI;
                return;
            }
            this.currentWriter.setPrefixForNamespace(prefix, namespaceURI);
        }
        catch (Exception e) {
            throw new MessageCreatingException(e);
        }
    }

    private String formatDimensions(int[] dims) {
        StringBuffer d = new StringBuffer();
        int i = 0;
        while (i < dims.length) {
            if (i > 0) {
                d.append(' ');
            }
            d.append(dims[i]);
            ++i;
        }
        return d.toString();
    }

    private void writeArrayPos(int[] arrayPos) throws MessageCreatingException {
        if (arrayPos == null) {
            return;
        }
        this.ensureArrayStacksSize(this.currentDepth);
        if (this.arraySizesStack[this.currentDepth] == null) {
            throw new MessageCreatingException("setting explicit array member position on a non-array member");
        }
        int intended = 0;
        int lowerOrder = 1;
        int i = 0;
        while (i < arrayPos.length) {
            intended += arrayPos[i] * lowerOrder;
            lowerOrder *= this.arraySizesStack[this.currentDepth][i];
            ++i;
        }
        if (intended < this.arrayPositionStack[this.currentDepth]) {
            throw new MessageCreatingException("setting array member position lower than the previous member's");
        }
        int i2 = this.arrayPositionStack[this.currentDepth];
        while (i2 < intended) {
            this.writeNil(NIL_ARRAY_MEMBER_QNAME, null);
            ++i2;
        }
        this.arrayPositionStack[this.currentDepth] = intended;
    }

    private void writeRemainingArrayMembers() throws MessageCreatingException {
        if (this.arraySizesStack[this.currentDepth] == null) {
            throw new MessageCreatingException("writeArrayEnd() called when not in an array");
        }
        int intended = 0;
        int lowerOrder = 1;
        int i = 0;
        while (i < this.arraySizesStack[this.currentDepth].length) {
            intended += (this.arraySizesStack[this.currentDepth][i] - 1) * lowerOrder;
            lowerOrder *= this.arraySizesStack[this.currentDepth][i];
            ++i;
        }
        ++intended;
        int i2 = this.arrayPositionStack[this.currentDepth];
        while (i2 < intended) {
            this.writeNil(NIL_ARRAY_MEMBER_QNAME, null);
            ++i2;
        }
    }

    public void init(Configurable conf) {
    }

    private void ensureArrayStacksSize(int size) {
        ++size;
        if (this.arraySizesStack == null) {
            this.arraySizesStack = new int[size + 10][];
            this.arrayPositionStack = new int[size + 10];
        }
        if (this.arraySizesStack.length < size) {
            int[][] tmp = new int[size + 10][];
            System.arraycopy(this.arraySizesStack, 0, tmp, 0, this.arraySizesStack.length);
            this.arraySizesStack = tmp;
            int[] tmp2 = new int[size + 10];
            System.arraycopy(this.arrayPositionStack, 0, tmp2, 0, this.arrayPositionStack.length);
            this.arrayPositionStack = tmp2;
        }
    }
}

