/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap;

import com.idoox.soap.EnvelopeCaching;
import com.idoox.xml.XmlWriter;
import com.idoox.xml.XmlWriterPool;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import org.idoox.util.Base64;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;

public class EnvelopeOutCache {
    public String envelopeStartTag;
    public String envelopeHeaderID;
    public String[] prefixes = null;
    public String[] namespaces = null;

    public static synchronized EnvelopeOutCache createEnvelopeOutCache(boolean writeSchemaNamespaces, Set namespaces, String soapNsUri, String envelopePrefix) throws IOException {
        if (!EnvelopeCaching.isEnabled()) {
            return null;
        }
        ArrayList<String> envelopePrefixes = new ArrayList<String>();
        ArrayList<String> envelopeNamespaces = new ArrayList<String>();
        envelopePrefixes.add(envelopePrefix);
        envelopeNamespaces.add(soapNsUri);
        envelopePrefixes.add("d");
        envelopeNamespaces.add("http://www.w3.org/2001/XMLSchema");
        envelopePrefixes.add("i");
        envelopeNamespaces.add("http://www.w3.org/2001/XMLSchema-instance");
        if (writeSchemaNamespaces) {
            int pos = 0;
            Iterator i = namespaces.iterator();
            while (i.hasNext()) {
                String ns = (String)i.next();
                if ("http://www.w3.org/XML/1998/namespace".equals(ns) || "http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns) || soapNsUri.equals(ns)) continue;
                envelopePrefixes.add("wn" + pos++);
                envelopeNamespaces.add(ns);
            }
        }
        EnvelopeOutCache envelopeOutCache = new EnvelopeOutCache();
        envelopeOutCache.prefixes = envelopePrefixes.toArray(new String[0]);
        envelopeOutCache.namespaces = envelopeNamespaces.toArray(new String[0]);
        XmlWriter xmlWriter = XmlWriterPool.getXmlWriter();
        StringWriter stringWriter = new StringWriter();
        xmlWriter.init(stringWriter, true);
        xmlWriter.enter(soapNsUri, "Envelope");
        int i = 0;
        while (i < envelopeOutCache.prefixes.length) {
            xmlWriter.setPrefixForNamespace(envelopeOutCache.prefixes[i], envelopeOutCache.namespaces[i]);
            ++i;
        }
        xmlWriter.flush();
        stringWriter.close();
        XmlWriterPool.releaseXmlWriter(xmlWriter);
        envelopeOutCache.envelopeStartTag = stringWriter.toString();
        byte[] envelopeBytes = envelopeOutCache.envelopeStartTag.getBytes("UTF-8");
        byte[] envelopeDigest = EnvelopeCaching.messageDigest.digest(envelopeBytes);
        envelopeDigest = Base64.encode(envelopeDigest, false);
        StringBuffer idBuffer = new StringBuffer();
        idBuffer.append(Integer.toHexString(envelopeBytes.length));
        idBuffer.append('-');
        idBuffer.append(new String(envelopeDigest, "ASCII"));
        envelopeOutCache.envelopeHeaderID = idBuffer.toString();
        return envelopeOutCache;
    }

    public static void prepareOutput(WaspInternalSOAPMessage waspMessage, Set namespaces, SOAPMethodInfo methodInfo, boolean writeNamespaces) throws IOException, SOAPException {
        if (EnvelopeCaching.isEnabled()) {
            SOAPPart soapPart = waspMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            EnvelopeOutCache envelopeOutCache = null;
            String xmlProtocol = waspMessage.getXMLProtocol();
            String envPrefix = waspMessage.getSOAPPart().getEnvelope().getElementName().getPrefix();
            if ("soap11".equals(xmlProtocol)) {
                envelopeOutCache = methodInfo.envelopeOutCache;
                if (envelopeOutCache == null) {
                    String envNS = envelope.getElementName().getURI();
                    methodInfo.envelopeOutCache = envelopeOutCache = EnvelopeOutCache.createEnvelopeOutCache(writeNamespaces, namespaces, envNS, envPrefix);
                }
            } else if ("soap12".equals(xmlProtocol) && (envelopeOutCache = methodInfo.envelopeOutCache1) == null) {
                String envNS = envelope.getElementName().getURI();
                methodInfo.envelopeOutCache1 = envelopeOutCache = EnvelopeOutCache.createEnvelopeOutCache(writeNamespaces, namespaces, envNS, envPrefix);
            }
            waspMessage.setEnvelopeOutCache(envelopeOutCache);
        }
    }
}

