/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap;

import com.idoox.debug.Category;
import com.idoox.soap.EnvelopeInCache;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EnvelopeCaching {
    public static final String PROPERTY_NAME = "wasp.soap.caching";
    public static final String HTTP_HEADER_NAME = "X-WASP-Message-ID";
    public static final String HTTP_HEADER_NAME_LC = "X-WASP-Message-ID".toLowerCase();
    private static final Category cat = Category.getCategory("com.idoox.soap.EnvelopeCaching");
    private static boolean enabled = true;
    public static MessageDigest messageDigest = null;
    private static final int MAX_OUT_CACHES = 15;
    private EnvelopeInCache[] envelopeInCaches = new EnvelopeInCache[15];
    private int nextCache = 0;
    private boolean disabled = false;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        EnvelopeCaching.enabled = enabled;
    }

    public void disable() {
        this.disabled = true;
    }

    public boolean disabled() {
        return this.disabled;
    }

    public final synchronized EnvelopeInCache findEnvelopeCache(String headerID) {
        int i = 0;
        while (i < this.nextCache) {
            if (this.envelopeInCaches[i].headerID.equals(headerID)) {
                EnvelopeInCache tempCache = this.envelopeInCaches[i];
                System.arraycopy(this.envelopeInCaches, 0, this.envelopeInCaches, 1, i);
                this.envelopeInCaches[0] = tempCache;
                return this.envelopeInCaches[0];
            }
            ++i;
        }
        return null;
    }

    public final synchronized void insertEnvelopeCache(EnvelopeInCache envelopeInCache) {
        if (this.nextCache < 15) {
            this.envelopeInCaches[this.nextCache++] = envelopeInCache;
        } else {
            System.arraycopy(this.envelopeInCaches, 0, this.envelopeInCaches, 1, 14);
            this.envelopeInCaches[0] = envelopeInCache;
        }
    }

    static {
        String soapCaching = System.getProperty(PROPERTY_NAME);
        if ("false".equalsIgnoreCase(soapCaching)) {
            EnvelopeCaching.setEnabled(false);
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            cat.debug("MD5 provider not found, switching off the SOAP Envelope optimizations", e);
            EnvelopeCaching.setEnabled(false);
        }
    }
}

