/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.config.accessor.file;

import com.idoox.config.accessor.ConfigAccessor;
import com.idoox.config.accessor.ConfigAccessorEvent;
import com.idoox.config.accessor.ConfigAccessorListener;
import com.idoox.debug.Category;
import com.idoox.debug.IndentCategory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.idoox.util.RuntimeWrappedException;

public class FileConfigAccessor
implements ConfigAccessor {
    private static final IndentCategory cat = new IndentCategory(Category.getCategory("com.idoox.config.accessor.file.FileConfigAccessor"));
    File applicationDirectory;
    String waspAppDirectoryCanonicalPath;
    HashMap configFiles = new HashMap();
    ArrayList globalListeners = new ArrayList();
    HashMap localListeners = new HashMap();
    String[] configFilePatterns;
    private HashMap changedMap = new HashMap();

    public void init(URL applicationURL, String[] configFilePatterns) throws IOException {
        this.init(applicationURL, configFilePatterns, true);
    }

    public void init(URL applicationURL, String[] configFilePatterns, boolean updateConfig) throws IOException {
        if (!applicationURL.getProtocol().equals("file")) {
            throw new RuntimeException("Trying to use FileAccessor to access general URLs");
        }
        this.applicationDirectory = new File(applicationURL.getFile());
        this.waspAppDirectoryCanonicalPath = this.applicationDirectory.getCanonicalPath();
        this.configFilePatterns = configFilePatterns;
        int i = 0;
        while (i < configFilePatterns.length) {
            ++i;
        }
        if (updateConfig) {
            this.update();
        }
    }

    public synchronized void addConfigAccessorListener(ConfigAccessorListener listener, URL config) {
        File configFile = null;
        if (config != null) {
            if (!config.getProtocol().equals("file")) {
                throw new RuntimeException("Trying to use FileAccessor to access general URLs");
            }
            configFile = new File(config.getFile());
        }
        if (configFile == null) {
            this.globalListeners.add(listener);
        } else {
            ArrayList<ConfigAccessorListener> l = (ArrayList<ConfigAccessorListener>)this.localListeners.get(configFile);
            if (l == null) {
                l = new ArrayList<ConfigAccessorListener>();
                this.localListeners.put(configFile, l);
            }
            l.add(listener);
        }
    }

    public synchronized void removeConfigAccessorListener(ConfigAccessorListener listener, URL config) {
        File configFile = null;
        if (config != null) {
            if (!config.getProtocol().equals("file")) {
                throw new RuntimeException("Trying to use FileAccessor to access general URLs");
            }
            configFile = new File(config.getFile());
        }
        if (configFile == null) {
            ((AbstractCollection)this.globalListeners).remove(listener);
        } else {
            ArrayList l = (ArrayList)this.localListeners.get(configFile);
            if (l == null) {
                return;
            }
            ((AbstractCollection)l).remove(listener);
        }
    }

    public Iterator getConfigFiles() {
        return this.configFiles.values().iterator();
    }

    public synchronized void update() throws IOException {
        this.processConfigFiles();
    }

    public synchronized void update(File config) throws IOException {
        this.processConfigFileInternal(config);
    }

    public synchronized void processConfigFiles() throws IOException {
        this.processConfigFilesInternal(this.applicationDirectory);
        Iterator i = this.configFiles.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            File f = (File)entry.getKey();
            long t = (Long)entry.getValue();
            if (!f.exists()) {
                i.remove();
                this.fireConfigAccessorEvent(3, f, this.guessAppDir(f));
                continue;
            }
            if (t == f.lastModified()) continue;
        }
    }

    public void addWatchedFile(URL watchedURL) {
        File watchedFile = new File(watchedURL.getFile());
        this.configFiles.put(watchedFile, new Long(watchedFile.lastModified()));
    }

    private void processConfigFileInternal(File file) throws IOException {
        if (file.isFile() && !this.configFiles.containsKey(file)) {
            this.configFiles.put(file, new Long(file.lastModified()));
            this.fireConfigAccessorEvent(1, file, this.applicationDirectory.getCanonicalPath());
        }
    }

    private synchronized void processConfigFilesInternal(File directory) throws IOException {
        int i = 0;
        while (i < this.configFilePatterns.length) {
            File file = new File(directory, this.configFilePatterns[i]);
            if (file.isFile() && !this.configFiles.containsKey(file)) {
                this.configFiles.put(file, new Long(file.lastModified()));
                this.fireConfigAccessorEvent(1, file, directory.getCanonicalPath());
            }
            ++i;
        }
        File[] subs = directory.listFiles();
        if (subs != null) {
            int i2 = 0;
            while (i2 < subs.length) {
                if (subs[i2].isDirectory()) {
                    this.processConfigFilesInternal(subs[i2]);
                }
                ++i2;
            }
        }
    }

    private void fireConfigAccessorEvent(int type, File f, String appDir) {
        try {
            if (appDir != null && (appDir.endsWith("/") || appDir.endsWith("\\"))) {
                appDir = appDir.substring(0, appDir.length() - 1);
            }
            ConfigAccessorEvent e = new ConfigAccessorEvent(type, f.toURL(), this.getConfigRelativePath(appDir));
            int s = this.globalListeners.size();
            int i = 0;
            while (i < s) {
                switch (type) {
                    case 1: {
                        ((ConfigAccessorListener)this.globalListeners.get(i)).configAdded(e);
                        break;
                    }
                    case 2: {
                        ((ConfigAccessorListener)this.globalListeners.get(i)).configChanged(e);
                        break;
                    }
                    case 3: {
                        ((ConfigAccessorListener)this.globalListeners.get(i)).configRemoved(e);
                    }
                }
                ++i;
            }
            ArrayList l = (ArrayList)this.localListeners.get(f);
            if (l == null) {
                return;
            }
            s = l.size();
            int i2 = 0;
            while (i2 < s) {
                switch (type) {
                    case 1: {
                        ((ConfigAccessorListener)l.get(i2)).configAdded(e);
                        break;
                    }
                    case 2: {
                        ((ConfigAccessorListener)l.get(i2)).configChanged(e);
                        break;
                    }
                    case 3: {
                        ((ConfigAccessorListener)l.get(i2)).configRemoved(e);
                    }
                }
                ++i2;
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Exception during parsing config file " + f, e);
        }
    }

    private String getConfigRelativePath(String configCanonical) throws IOException {
        String relativePath = null;
        if (configCanonical == null) {
            return null;
        }
        if (configCanonical.startsWith(this.waspAppDirectoryCanonicalPath) && ((relativePath = configCanonical.substring(this.waspAppDirectoryCanonicalPath.length())).startsWith("/") || relativePath.startsWith("\\"))) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    private String guessAppDir(File f) throws IOException {
        String canonicalPath = f.getCanonicalPath();
        int i = 0;
        while (i < this.configFilePatterns.length) {
            if (canonicalPath.endsWith(this.configFilePatterns[i])) {
                return canonicalPath.substring(0, canonicalPath.length() - this.configFilePatterns[i].length());
            }
            ++i;
        }
        return null;
    }
}

