/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.idoox.debug.Category;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import org.idoox.security.SecurityConfigs;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public abstract class GSSManager {
    private static List providers = new ArrayList(3);
    private static Category dbg = Category.getCategory((class$org$ietf$jgss$GSSManager == null ? (class$org$ietf$jgss$GSSManager = GSSManager.class$("org.ietf.jgss.GSSManager")) : class$org$ietf$jgss$GSSManager).getName());
    static /* synthetic */ Class class$org$ietf$jgss$GSSManager;

    private static synchronized GSSManager LoadProvider(String name) {
        try {
            Class<?> class1 = Class.forName(name);
            Object obj = class1.newInstance();
            return (GSSManager)obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dbg.error("Cannot load providers " + exception.getMessage());
            return null;
        }
    }

    private static synchronized void LoadProviders() {
        String s;
        int i = 1;
        while ((s = SecurityConfigs.getSecurityConfig().getProperty("security.provider." + i++)) != null) {
            GSSManager provider = GSSManager.LoadProvider(s.trim());
            if (provider == null) continue;
            providers.add(provider);
        }
    }

    public static GSSManager getInstance() throws NoSuchProviderException {
        if (providers.size() > 0) {
            return (GSSManager)providers.get(0);
        }
        GSSManager.LoadProviders();
        if (providers.size() > 0) {
            return (GSSManager)providers.get(0);
        }
        throw new NoSuchProviderException("Unable to load GSS providers.");
    }

    public abstract Oid[] getMechs();

    public abstract Oid[] getNamesForMech(Oid var1) throws GSSException;

    public abstract Oid[] getMechsForName(Oid var1);

    public abstract GSSName createName(String var1, Oid var2) throws GSSException;

    public abstract GSSName createName(byte[] var1, Oid var2) throws GSSException;

    public abstract GSSName createName(String var1, Oid var2, Oid var3) throws GSSException;

    public abstract GSSName createName(byte[] var1, Oid var2, Oid var3) throws GSSException;

    public abstract GSSCredential createCredential(int var1) throws GSSException;

    public abstract GSSCredential createCredential(GSSName var1, int var2, Oid var3, int var4) throws GSSException;

    public abstract GSSCredential createCredential(GSSName var1, int var2, Oid[] var3, int var4) throws GSSException;

    public abstract GSSContext createContext(GSSName var1, Oid var2, GSSCredential var3, int var4) throws GSSException;

    public abstract GSSContext createContext(GSSCredential var1) throws GSSException;

    public abstract GSSContext createContext(byte[] var1) throws GSSException;

    public abstract void addProviderAtFront(Provider var1, Oid var2) throws GSSException;

    public abstract void addProviderAtEnd(Provider var1, Oid var2) throws GSSException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

