/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

public class GSSException
extends Exception {
    public static final int BAD_BINDINGS = 4;
    public static final int BAD_MECH = 1;
    public static final int BAD_NAME = 2;
    public static final int BAD_NAMETYPE = 3;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int CONTEXT_EXPIRED = 12;
    public static final int CREDENTIALS_EXPIRED = 11;
    public static final int DEFECTIVE_CREDENTIAL = 10;
    public static final int DEFECTIVE_TOKEN = 9;
    public static final int FAILURE = 13;
    public static final int NO_CONTEXT = 8;
    public static final int NO_CRED = 7;
    public static final int BAD_QOP = 14;
    public static final int UNATHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    public static final int DUPLICATE_TOKEN = 20;
    public static final int OLD_TOKEN = 19;
    public static final int UNSEQ_TOKEN = 21;
    public static final int GAP_TOKEN = 22;
    protected int majorCode;
    protected int minorCode;
    protected String minorString;

    public GSSException(int majorCode) {
        this.majorCode = majorCode;
    }

    public GSSException(int majorCode, int minorCode, String minorString) {
        this.majorCode = majorCode;
        this.minorCode = minorCode;
        this.minorString = minorString;
    }

    public int getMajor() {
        return this.majorCode;
    }

    public int getMinor() {
        return this.minorCode;
    }

    public String getMajorString() {
        switch (this.majorCode) {
            case 4: {
                return "Channel bindings mismatch error";
            }
            case 1: {
                return "Unsupported mechanism requested error.";
            }
            case 2: {
                return "Invalid name provided error.";
            }
            case 3: {
                return "Name of unsupported type provided error.";
            }
            case 5: {
                return "Invalid status code error";
            }
            case 6: {
                return "Token had invalid integrity check error.";
            }
            case 12: {
                return "Specified security context expired error.";
            }
            case 11: {
                return "Expired credentials detected error.";
            }
            case 10: {
                return "Defective credential error.";
            }
            case 9: {
                return "Defective token error.";
            }
            case 13: {
                return "General failure, unspecified at GSS-API level.";
            }
            case 8: {
                return "Invalid security context error.";
            }
            case 7: {
                return "Invalid credentials error.";
            }
            case 14: {
                return "Unsupported QOP value error.";
            }
            case 15: {
                return "Operation unauthorized error.";
            }
            case 16: {
                return "Operation unavailable error.";
            }
            case 17: {
                return "Duplicate credential element requested error.";
            }
            case 18: {
                return "Name contains multi-mechanism elements error.";
            }
            case 20: {
                return "The token was a duplicate of an earlier token.";
            }
            case 19: {
                return "The token's validity period has expired.";
            }
            case 21: {
                return "A later token has already been processed.";
            }
            case 22: {
                return "An expected per-message token was not received.";
            }
        }
        return "Invalid Error Code.";
    }

    public String getMinorString() {
        return this.minorString;
    }

    public void setMinor(int minorCode, String message) {
        this.minorCode = minorCode;
        this.minorString = message;
    }

    public String toString() {
        return "Major Code: " + this.majorCode + " " + this.getMajorString() + "\nMinor Code: " + this.minorCode + " " + this.minorString;
    }

    public String getMessage() {
        return this.toString();
    }
}

