/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.security.pstore;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.idoox.security.pstore.NotificationEvent;
import org.idoox.security.pstore.NotificationListener;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.pstore.UserIterator;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.pstore.UserStoreException;
import org.idoox.security.pstore.UserStoreSource;

public abstract class AbstractUserStore
implements UserStore {
    protected Vector listeners = new Vector();

    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean match(String userId, String pureUserFilter, boolean checkStart, boolean checkEnd) {
        if (pureUserFilter == null || pureUserFilter.length() == 0) {
            return true;
        }
        if (userId == null) {
            return false;
        }
        if (checkEnd) {
            if (checkStart) {
                return userId.indexOf(pureUserFilter) >= 0;
            }
            return userId.endsWith(pureUserFilter);
        }
        if (checkStart) {
            return userId.startsWith(pureUserFilter);
        }
        return userId.equals(pureUserFilter);
    }

    protected void fireDeleteUserAction(String userName) {
        int i = 0;
        while (i < this.listeners.size()) {
            NotificationListener dest = (NotificationListener)this.listeners.elementAt(i);
            dest.notificationReceived(new NotificationEvent(this, userName, 1));
            ++i;
        }
    }

    public void destroy() {
    }

    public abstract Iterator getSupportedAttributes();

    public abstract PropertySerializer getPropertySerializer(String var1) throws UserStoreException;

    public abstract void setPropertySerializer(String var1, PropertySerializer var2) throws UserStoreException;

    public abstract void setUserStoreSource(UserStoreSource var1);

    public abstract String[] getUserIds();

    public abstract UserIterator getUsers(Map var1);

    public abstract UserIterator getUsers();

    public abstract void setUserProperty(String var1, String var2, Object var3) throws UserStoreException;

    public abstract void setUserProperties(String var1, Map var2) throws UserStoreException;

    public abstract void removeUserProperty(String var1, String var2) throws UserStoreException;

    public abstract Object getUserProperty(String var1, String var2) throws UserStoreException;

    public abstract Map getUserProperties(String var1) throws UserStoreException;

    public abstract boolean hasUser(String var1, Map var2);

    public abstract void deleteUser(String var1) throws UserStoreException;
}

