/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.security;

import com.idoox.debug.Category;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.idoox.security.SecurityConfig;
import org.idoox.security.util.RuntimeWrappedException;

public final class SecurityConfigs {
    private static Category dbg = Category.getCategory((class$org$idoox$security$SecurityConfigs == null ? (class$org$idoox$security$SecurityConfigs = SecurityConfigs.class$("org.idoox.security.SecurityConfigs")) : class$org$idoox$security$SecurityConfigs).getName());
    private static SecurityConfig globalSecConf;
    private static Map localSecConfs;
    private static int localSecConfCnt;
    static /* synthetic */ Class class$org$idoox$security$SecurityConfigs;

    public static SecurityConfig getSecurityConfig() {
        return globalSecConf;
    }

    public static SecurityConfig getLocalSecurityConfig(String id) {
        return (SecurityConfig)localSecConfs.get(id);
    }

    private static synchronized void doInit() {
        localSecConfs = new HashMap(3);
        ClassLoader implClassLoader = (class$org$idoox$security$SecurityConfigs == null ? (class$org$idoox$security$SecurityConfigs = SecurityConfigs.class$("org.idoox.security.SecurityConfigs")) : class$org$idoox$security$SecurityConfigs).getClassLoader();
        String configFileName = System.getProperty("idoox.security.config");
        boolean success = false;
        Properties properties = new Properties();
        if (configFileName != null) {
            try {
                InputStream configFile = configFileName.startsWith("resource://") ? (class$org$idoox$security$SecurityConfigs == null ? (class$org$idoox$security$SecurityConfigs = SecurityConfigs.class$("org.idoox.security.SecurityConfigs")) : class$org$idoox$security$SecurityConfigs).getClassLoader().getResourceAsStream(configFileName.substring(11)) : new FileInputStream(configFileName);
                properties.load(configFile);
                success = true;
            }
            catch (Exception e) {
                dbg.error("Cannot load security configuration from '" + configFileName + "' using default values");
            }
        }
        if (configFileName == null || !success) {
            try {
                if ((class$org$idoox$security$SecurityConfigs == null ? (class$org$idoox$security$SecurityConfigs = SecurityConfigs.class$("org.idoox.security.SecurityConfigs")) : class$org$idoox$security$SecurityConfigs).getClassLoader() == null) {
                    properties.load(ClassLoader.getSystemResourceAsStream("com/idoox/security/gss.properties"));
                } else {
                    properties.load((class$org$idoox$security$SecurityConfigs == null ? (class$org$idoox$security$SecurityConfigs = SecurityConfigs.class$("org.idoox.security.SecurityConfigs")) : class$org$idoox$security$SecurityConfigs).getClassLoader().getResourceAsStream("com/idoox/security/gss.properties"));
                }
            }
            catch (IOException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        globalSecConf = new SecurityConfig();
        globalSecConf.init(properties, implClassLoader);
    }

    static String registerConfig(SecurityConfig config) {
        String confId = String.valueOf(++localSecConfCnt);
        localSecConfs.put(confId, config);
        return confId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        localSecConfCnt = 0;
        SecurityConfigs.doInit();
    }
}

