/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;

public class SubjectPublicKeyInfo
extends Sequence {
    private Category dbg = Category.getCategory((class$com$idoox$security$x509$SubjectPublicKeyInfo == null ? (class$com$idoox$security$x509$SubjectPublicKeyInfo = SubjectPublicKeyInfo.class$("com.idoox.security.x509.SubjectPublicKeyInfo")) : class$com$idoox$security$x509$SubjectPublicKeyInfo).getName());
    private AlgorithmId algId;
    private byte[] publicKey;
    static /* synthetic */ Class class$com$idoox$security$x509$SubjectPublicKeyInfo;

    public SubjectPublicKeyInfo(AlgorithmId algId, byte[] publicKey) {
        this.algId = algId;
        this.addComponent(this.algId);
        this.publicKey = publicKey;
        this.addComponent(new BitString(this.publicKey));
    }

    public SubjectPublicKeyInfo(PublicKey subjectPublicKey) {
        try {
            byte[] encoded = subjectPublicKey.getEncoded();
            ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
            this.init(bin);
        }
        catch (Exception e) {
            this.dbg.error("Error during init from given public key: ", e);
        }
    }

    public SubjectPublicKeyInfo(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SubjectPublicKeyInfo(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.algId = new AlgorithmId(((Sequence)this.components.get(0)).encode());
        this.publicKey = ((BitString)this.components.get(1)).getBytes();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algId;
    }

    public String getAlgorithmName() {
        return OID.getAlgName(this.algId.getOid());
    }

    public byte[] getSubjectPublicKey() {
        return this.publicKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

