/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Asn1String;
import com.idoox.security.asn1.Oid;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.util.OID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AVA
extends Sequence {
    private String type;
    private String value;

    public AVA(String type, String value) throws Asn1Exception {
        this.type = type.indexOf(46) != -1 ? type : OID.getAlgOid(type);
        this.addComponent(new Oid(this.type));
        this.value = value;
        int stringType = 19;
        if (this.type.equals("1.2.840.113549.1.9.1")) {
            stringType = 22;
        }
        this.addComponent(new Asn1String(stringType, this.value));
    }

    public AVA(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public AVA(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.type = ((Oid)this.components.get(0)).getOid();
        this.value = ((Asn1String)this.components.get(1)).getString();
    }

    public String getRawName() {
        return this.type + "=" + this.value;
    }

    public String getName() {
        return OID.getAlgName(this.type) + "=" + this.value;
    }

    public String getType() {
        return OID.getAlgName(this.type);
    }

    public String getValue() {
        return this.value;
    }
}

