/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.SecureRandom;

public class Random {
    private static Category dbg = Category.getCategory("com.idoox.security.util.Random");
    private static SecureRandom rand;
    private static final int SEED_LENGTH = 2;
    private static volatile int returnedCount;
    private static String seedFile;

    public static synchronized SecureRandom getRandom() {
        if (returnedCount % 100 == 0) {
            Random.saveSeed();
        }
        ++returnedCount;
        return rand;
    }

    public static void saveSeed() {
        byte[] seed = SecureRandom.getSeed(2);
        try {
            FileOutputStream fos = new FileOutputStream(seedFile);
            fos.write(seed);
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        returnedCount = 0;
        seedFile = System.getProperty("user.home") + "/.idoox.random";
        try {
            byte[] seed = new byte[2];
            FileInputStream fis = new FileInputStream(seedFile);
            fis.read(seed, 0, 2);
            fis.close();
            rand = new SecureRandom(seed);
            rand.nextInt();
        }
        catch (Exception e) {
            rand = new SecureRandom();
            rand.nextInt();
            Random.saveSeed();
        }
    }
}

