/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.util.Random;
import com.idoox.security.x509.SubjectPublicKeyInfo;
import com.idoox.security.x509.TBSCertificate;
import com.idoox.security.x509.Validity;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.idoox.security.util.RuntimeWrappedException;

public class IdentityGenerator {
    private Category dbg = Category.getCategory((class$com$idoox$security$util$IdentityGenerator == null ? (class$com$idoox$security$util$IdentityGenerator = IdentityGenerator.class$("com.idoox.security.util.IdentityGenerator")) : class$com$idoox$security$util$IdentityGenerator).getName());
    private static final String KEY_ALG_NAME = "RSA";
    private static final String SIG_ALG_NAME = "MD5WithRSA";
    private static final int KEY_SIZE = 1024;
    private static final int CERTIFICATE_VALIDITY = 730;
    private String name;
    private X500Name subject;
    private PrivateKey privateKey;
    private Certificate[] certChain;
    static /* synthetic */ Class class$com$idoox$security$util$IdentityGenerator;

    public IdentityGenerator(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Both name and password must be specified");
        }
        this.name = name;
        try {
            this.subject = new X500Name("CN=" + name);
        }
        catch (Asn1Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public IdentityGenerator(String name, X500Name subject) {
        if (name == null || subject == null) {
            throw new IllegalArgumentException("All arguments must be specified");
        }
        this.name = name;
        this.subject = subject;
    }

    public void generate() throws SignatureException, NoSuchAlgorithmException, CertificateException {
        if (this.certChain != null) {
            throw new RuntimeException("Identity already generated");
        }
        KeyPairGenerator gen = KeyPairGenerator.getInstance(KEY_ALG_NAME);
        gen.initialize(1024, Random.getRandom());
        KeyPair keyPair = gen.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyPair.getPublic());
        Validity validity = new Validity(730);
        TBSCertificate tbsCert = new TBSCertificate(0, BigInteger.valueOf(System.currentTimeMillis()), SIG_ALG_NAME, this.subject, validity, this.subject, spki, null, null, null);
        com.idoox.security.x509.Certificate cert = new com.idoox.security.x509.Certificate(tbsCert, this.privateKey);
        this.certChain = new Certificate[1];
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ByteArrayInputStream bin = new ByteArrayInputStream(cert.encode());
        this.certChain[0] = cf.generateCertificate(bin);
    }

    public Certificate[] getCertificateChain() {
        return this.certChain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

