/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

public final class Base64 {
    private static final byte[] encodeTable = new byte[64];
    private static final byte[] decodeTable;

    public static byte[] encode(byte[] binary, boolean newLines) {
        return Base64.encode(binary, binary.length, newLines);
    }

    public static byte[] encode(byte[] binary, int length, boolean newLines) {
        int binLength = length / 3;
        int binOver = length % 3;
        int binSize = binLength + (binOver == 0 ? 0 : 1);
        int addSize = newLines ? (binSize - 1) / 19 + 1 : 0;
        byte[] base64 = new byte[binSize * 4 + addSize];
        int binI = 0;
        int baseI = 0;
        int nlCounter = 0;
        int b1 = 0;
        int b2 = 0;
        int b3 = 0;
        int i = 0;
        while (i < binLength) {
            b1 = binary[binI] + 256;
            b2 = binary[binI + 1] + 256;
            b3 = binary[binI + 2] + 256;
            base64[baseI] = encodeTable[(b1 & 0xFC) >> 2];
            base64[baseI + 1] = encodeTable[(b1 & 3) << 4 | (b2 & 0xF0) >> 4];
            base64[baseI + 2] = encodeTable[(b2 & 0xF) << 2 | (b3 & 0xC0) >> 6];
            base64[baseI + 3] = encodeTable[b3 & 0x3F];
            binI += 3;
            baseI += 4;
            if (newLines && ++nlCounter == 19) {
                if (i + 1 >= binLength) {
                    if (binOver != 0) {
                        base64[baseI++] = 10;
                    }
                } else {
                    nlCounter = 0;
                    base64[baseI++] = 10;
                }
            }
            ++i;
        }
        if (binOver == 1) {
            b1 = binary[binI] + 256;
            base64[baseI] = encodeTable[(b1 & 0xFC) >> 2];
            base64[baseI + 1] = encodeTable[(b1 & 3) << 4];
            base64[baseI + 2] = 61;
            base64[baseI + 3] = 61;
            baseI += 4;
        } else if (binOver == 2) {
            b1 = binary[binI] + 256;
            b2 = binary[binI + 1] + 256;
            base64[baseI] = encodeTable[(b1 & 0xFC) >> 2];
            base64[baseI + 1] = encodeTable[(b1 & 3) << 4 | (b2 & 0xF0) >> 4];
            base64[baseI + 2] = encodeTable[(b2 & 0xF) << 2];
            base64[baseI + 3] = 61;
            baseI += 4;
        }
        if (newLines) {
            base64[baseI] = 10;
        }
        return base64;
    }

    public static byte[] decode(byte[] base64) {
        int baseLength = base64.length;
        byte[] binary = new byte[(baseLength >> 2) * 3];
        int baseI = 0;
        int binI = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int b4 = 0;
        while (baseI < baseLength) {
            if (baseI + 3 < baseLength) {
                b1 = decodeTable[base64[baseI]];
                b2 = decodeTable[base64[baseI + 1]];
                b3 = decodeTable[base64[baseI + 2]];
                b4 = decodeTable[base64[baseI + 3]];
                if ((b1 | b2 | b3 | b4) >= 0) {
                    baseI += 4;
                } else {
                    b4 = -1;
                    while (baseI < baseLength && (b1 = decodeTable[base64[baseI++]]) < 0) {
                    }
                    while (baseI < baseLength && (b2 = decodeTable[base64[baseI++]]) < 0) {
                    }
                    while (baseI < baseLength && (b3 = decodeTable[base64[baseI++]]) == -1) {
                    }
                    while (baseI < baseLength && (b4 = decodeTable[base64[baseI++]]) == -1) {
                    }
                }
            } else {
                b4 = -1;
                while (baseI < baseLength && (b1 = decodeTable[base64[baseI++]]) < 0) {
                }
                while (baseI < baseLength && (b2 = decodeTable[base64[baseI++]]) < 0) {
                }
                while (baseI < baseLength && (b3 = decodeTable[base64[baseI++]]) == -1) {
                }
                while (baseI < baseLength && (b4 = decodeTable[base64[baseI++]]) == -1) {
                }
            }
            if (b4 == -2) {
                binary[binI++] = (byte)(b1 << 2 | b2 >>> 4);
                if (b3 == -2) break;
                binary[binI++] = (byte)((b2 & 0xF) << 4 | b3 >>> 2);
                break;
            }
            if (baseI >= baseLength && b4 == -1) break;
            binary[binI++] = (byte)(b1 << 2 | b2 >>> 4);
            binary[binI++] = (byte)((b2 & 0xF) << 4 | b3 >>> 2);
            binary[binI++] = (byte)((b3 & 3) << 6 | b4);
        }
        if (binI < baseLength) {
            byte[] tempBinary = new byte[binI];
            System.arraycopy(binary, 0, tempBinary, 0, binI);
            return tempBinary;
        }
        return binary;
    }

    public static byte[] encode(byte[] binary) {
        return Base64.encode(binary, true);
    }

    static {
        int i = 0;
        while (i < 26) {
            Base64.encodeTable[i] = (byte)(65 + i);
            ++i;
        }
        int i2 = 0;
        while (i2 < 26) {
            Base64.encodeTable[i2 + 26] = (byte)(97 + i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < 10) {
            Base64.encodeTable[i3 + 52] = (byte)(48 + i3);
            ++i3;
        }
        Base64.encodeTable[62] = 43;
        Base64.encodeTable[63] = 47;
        decodeTable = new byte[256];
        int i4 = 0;
        while (i4 < decodeTable.length) {
            Base64.decodeTable[i4] = -1;
            ++i4;
        }
        int i5 = 0;
        while (i5 < 26) {
            Base64.decodeTable[i5 + 65] = (byte)i5;
            ++i5;
        }
        int i6 = 0;
        while (i6 < 26) {
            Base64.decodeTable[i6 + 97] = (byte)(i6 + 26);
            ++i6;
        }
        int i7 = 0;
        while (i7 < 10) {
            Base64.decodeTable[i7 + 48] = (byte)(i7 + 52);
            ++i7;
        }
        Base64.decodeTable[43] = 62;
        Base64.decodeTable[47] = 63;
        Base64.decodeTable[61] = -2;
    }
}

