/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pkcs;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.asn1.SetOf;
import com.idoox.security.pkcs.Attribute;
import com.idoox.security.x509.SubjectPublicKeyInfo;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CertificationRequestInfo
extends Sequence {
    private int version = 0;
    private X500Name subject;
    private SubjectPublicKeyInfo subjectPKInfo;
    private HashMap attributes;

    public CertificationRequestInfo(X500Name subject, SubjectPublicKeyInfo subjectPKInfo, Set attributes) {
        this.addComponent(new Integer(this.version));
        this.subject = subject;
        this.addComponent(this.subject);
        this.subjectPKInfo = subjectPKInfo;
        this.addComponent(this.subjectPKInfo);
        if (attributes != null) {
            this.attributes = new HashMap(attributes.size());
            Iterator it = attributes.iterator();
            Implicit imp = new Implicit(-128, 0);
            SetOf set = new SetOf();
            while (it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                this.attributes.put(attr.getType(), attr);
                set.addComponent(attr);
            }
            imp.addComponent(set);
            this.addComponent(imp);
        } else {
            this.attributes = null;
        }
    }

    public CertificationRequestInfo(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public CertificationRequestInfo(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.version = ((Integer)this.components.get(0)).getInt();
        if (this.version != 0) {
            throw new Asn1Exception("Unsupported certification request version");
        }
        this.subject = new X500Name(((Sequence)this.components.get(1)).encode());
        this.subjectPKInfo = new SubjectPublicKeyInfo(((Sequence)this.components.get(2)).encode());
        if (this.components.size() > 3) {
            if (((Asn1)this.components.get(3)).getTagNumber() != 0) throw new Asn1Exception("Invalid tag number");
            Constructed set = (Constructed)this.components.get(3);
            this.attributes = new HashMap(set.getComponents().size());
            Iterator it = ((AbstractList)set.getComponents()).iterator();
            while (it.hasNext()) {
                Attribute attr = new Attribute(((Asn1)it.next()).encode());
                this.attributes.put(attr.getType(), attr);
            }
            return;
        } else {
            this.attributes = null;
        }
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPKInfo() {
        return this.subjectPKInfo;
    }

    public Set getAttributesOIDs() {
        if (this.attributes != null) {
            return this.attributes.keySet();
        }
        return null;
    }

    public Attribute getAttribute(String type) {
        if (this.attributes != null) {
            return (Attribute)this.attributes.get(type);
        }
        return null;
    }
}

