/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.jaas;

import com.idoox.debug.Category;
import com.idoox.security.jaas.CallContextCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.jaas.SmLoginParamsCredential;

public class SmLoginModule
implements LoginModule {
    private static Category log = Category.getCategory("com.idoox.security.jaas.SmLoginModule");
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;
    public static String CALL_CONTEXT_PARAM_KEY = "callContextParamKey";
    public static final String USER_HEADER_NAME = "SM-USERDN";
    private Subject subject = null;
    private WASPPrincipal principal = null;
    private boolean commitSucceeded = false;
    private SmLoginParamsCredential cred = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CallContextCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            log.error("", e);
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            log.error("", e);
            throw new LoginException(e.getMessage());
        }
        Map callContext = (Map)((CallContextCallback)callbacks[0]).getCallContext();
        Map params = (Map)callContext.get(CALL_CONTEXT_PARAM_KEY);
        if (params == null) {
            log.error("Unable to get siteminder parameters, login fails");
            this.succeeded = false;
            return false;
        }
        String username = (String)params.get(USER_HEADER_NAME);
        this.principal = new WASPPrincipal(username);
        this.cred = new SmLoginParamsCredential(params);
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        Set<Object> creds;
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
        }
        if (!(creds = this.subject.getPublicCredentials()).contains(this.cred)) {
            creds.add(this.cred);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
            this.cred = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            Set<Object> creds;
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals.contains(this.principal)) {
                principals.remove(this.principal);
            }
            if ((creds = this.subject.getPublicCredentials()).contains(this.cred)) {
                creds.remove(this.cred);
            }
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        this.cred = null;
        return true;
    }
}

