/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.jaas;

import com.idoox.debug.Category;
import com.idoox.security.jaas.GSSCredentialSupport;
import com.idoox.security.util.GSSHelper;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.jaas.ConfigIdCallback;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSLoginModule
implements LoginModule {
    private static Category dbg = Category.getCategory((class$com$idoox$security$jaas$GSSLoginModule == null ? (class$com$idoox$security$jaas$GSSLoginModule = GSSLoginModule.class$("com.idoox.security.jaas.GSSLoginModule")) : class$com$idoox$security$jaas$GSSLoginModule).getName());
    private CallbackHandler handler;
    private Subject subject;
    private boolean succeeded;
    private boolean commitSucceeded;
    private WASPPrincipal principal;
    private GSSCredential cred;
    static /* synthetic */ Class class$com$idoox$security$jaas$GSSLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.handler = callbackHandler;
        this.subject = subject;
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        String name = null;
        char[] password = null;
        String configId = "";
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Enter name"), new PasswordCallback("Enter password", false), new ConfigIdCallback()};
            this.handler.handle(callbacks);
            name = ((NameCallback)callbacks[0]).getName();
            password = ((PasswordCallback)callbacks[1]).getPassword();
            configId = ((ConfigIdCallback)callbacks[2]).getConfigId();
        }
        catch (IOException e) {
            throw new FailedLoginException("Cannot get information from the callback handler");
        }
        catch (UnsupportedCallbackException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        try {
            GSSManager gss = GSSHelper.getManager1(configId);
            this.principal = new WASPPrincipal(name);
            Class clazz = class$com$idoox$security$jaas$GSSLoginModule == null ? (class$com$idoox$security$jaas$GSSLoginModule = GSSLoginModule.class$("com.idoox.security.jaas.GSSLoginModule")) : class$com$idoox$security$jaas$GSSLoginModule;
            synchronized (clazz) {
                GSSCredentialSupport.setPassword(new String(password));
                this.cred = gss.createCredential(gss.createName(name, GSSName.NT_USER_NAME), 0, (Oid)null, 0);
                GSSCredentialSupport.setPassword(null);
            }
            this.succeeded = true;
        }
        catch (GSSException e) {
            throw new FailedLoginException(e.getMessage());
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        Set<Object> creds;
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
        }
        if (!(creds = this.subject.getPrivateCredentials()).contains(this.cred)) {
            creds.add(this.cred);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
            this.cred = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            Set<Object> creds;
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals.contains(this.principal)) {
                principals.remove(this.principal);
            }
            if ((creds = this.subject.getPrivateCredentials()).contains(this.cred)) {
                creds.remove(this.cred);
            }
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        this.cred = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

