/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.httpdigest;

import com.idoox.debug.Category;
import com.idoox.security.httpdigest.AuthorizationStructureImpl;
import com.idoox.security.httpdigest.HttpDigestHelper;
import com.idoox.security.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.idoox.security.httpdigest.AuthorizationStructure;

public class DigestCalculator {
    private static final Category log = Category.getCategory("com.idoox.wasp.security.http.digest.DigestCalculator");

    private static String cvtHex(byte[] bin) {
        char[] hex = new char[2 * bin.length];
        int HASHLEN = 16;
        int i = 0;
        while (i < HASHLEN) {
            char j = (char)(bin[i] >> 4 & 0xF);
            hex[i * 2] = j <= '\t' ? (char)(j + 48) : (char)(j + 97 - 10);
            j = (char)(bin[i] & 0xF);
            hex[i * 2 + 1] = j <= '\t' ? (char)(j + 48) : (char)(j + 97 - 10);
            i = (short)(i + 1);
        }
        return new String(hex);
    }

    private static String digestCalcHA1(String realm, String algorithm, String nonce, String userName, String password, String cnonce, boolean msPeer) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = null;
        if (algorithm == null || "MD5".equalsIgnoreCase(algorithm) || "MD5-SESS".equalsIgnoreCase(algorithm)) {
            md = MessageDigest.getInstance("MD5");
        } else if ("SHA".equalsIgnoreCase(algorithm)) {
            md = MessageDigest.getInstance("SHA");
        } else {
            log.error("algorithm not supported: " + algorithm);
        }
        md.reset();
        String A1 = userName + ":" + realm + ":" + password;
        byte[] digest = md.digest(A1.getBytes("UTF-8"));
        if ("MD5-SESS".equalsIgnoreCase(algorithm)) {
            md.update(msPeer ? DigestCalculator.cvtHex(digest).getBytes("UTF-8") : digest);
            if (cnonce == null) {
                cnonce = "";
            }
            String sess = ":" + nonce + ":" + cnonce;
            md.update(sess.getBytes("UTF-8"));
            digest = md.digest();
        }
        String ret = DigestCalculator.cvtHex(digest);
        return ret;
    }

    private static String digestCalcHA2(String method, String uri, String qop, String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String A2 = method + ":" + uri;
        if ("auth-int".equalsIgnoreCase(qop)) {
            throw new RuntimeException("auth-int algorithm not implemented");
        }
        MessageDigest md = null;
        if (algorithm == null || "MD5".equalsIgnoreCase(algorithm) || "MD5-SESS".equalsIgnoreCase(algorithm)) {
            md = MessageDigest.getInstance("MD5");
        } else if ("SHA".equalsIgnoreCase(algorithm)) {
            md = MessageDigest.getInstance("SHA");
        }
        md.reset();
        byte[] digest = md.digest(A2.getBytes("UTF-8"));
        return DigestCalculator.cvtHex(digest);
    }

    public static String digestCalcResponse(AuthorizationStructure author, String userName, String password, String method) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = null;
        boolean msPeer = HttpDigestHelper.isPeerMicrosoft(((AuthorizationStructureImpl)author).getPeer());
        if (author.getAlgorithm() == null || "MD5".equalsIgnoreCase(author.getAlgorithm()) || "MD5-SESS".equalsIgnoreCase(author.getAlgorithm())) {
            md = MessageDigest.getInstance("MD5");
        } else if ("SHA".equalsIgnoreCase(author.getAlgorithm())) {
            md = MessageDigest.getInstance("SHA");
        } else if ("WS-SHA1".equals(author.getAlgorithm())) {
            byte[] nonce = Base64.decode(author.getNonce().getBytes("UTF-8"));
            return new String(Base64.encode(DigestCalculator.getWsSha1PasswordDigest(nonce, author.getCreated(), password)), "UTF-8");
        }
        md.reset();
        String HA1 = DigestCalculator.digestCalcHA1(author.getRealm(), author.getAlgorithm(), author.getNonce(), userName, password, author.getCnonce(), msPeer);
        String HA2 = DigestCalculator.digestCalcHA2(method, author.getUri(), author.getQop(), author.getAlgorithm());
        String toCalc = HA1 + ":" + author.getNonce() + ":";
        if (author.getQop() != null) {
            toCalc = toCalc + author.getNc() + ":" + author.getCnonce() + ":" + author.getQop() + ":";
        }
        toCalc = toCalc + HA2;
        byte[] digest = md.digest(toCalc.getBytes("UTF-8"));
        return DigestCalculator.cvtHex(digest);
    }

    public static byte[] getWsSha1PasswordDigest(byte[] nonce, String formattedCreated, String password) {
        if (formattedCreated == null || nonce == null || password == null) {
            throw new RuntimeException("Don't have enough information to compute the password digest");
        }
        byte[] createdBytes = null;
        byte[] passwordBytes = null;
        try {
            createdBytes = formattedCreated.getBytes("UTF-8");
            passwordBytes = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        byte[] buffer = new byte[createdBytes.length + passwordBytes.length + nonce.length];
        System.arraycopy(nonce, 0, buffer, 0, nonce.length);
        System.arraycopy(createdBytes, 0, buffer, nonce.length, createdBytes.length);
        System.arraycopy(passwordBytes, 0, buffer, nonce.length + createdBytes.length, passwordBytes.length);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("", e);
            return null;
        }
        return md.digest(buffer);
    }
}

