/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Primitive;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Implicit
extends Asn1 {
    protected byte type;
    protected Asn1 comp;

    public Implicit(byte classType, byte tagNum) {
        this.classType = classType;
        this.tagNum = tagNum;
    }

    public void addComponent(Asn1 comp) {
        this.comp = comp;
        if (comp instanceof Primitive) {
            this.type = 0;
        } else if (comp instanceof Constructed) {
            this.type = (byte)32;
        } else {
            this.comp = null;
        }
        if (this.comp.encoded != null) {
            byte tag = this.comp.encoded[0];
            byte tagnum = (byte)(tag & 0x1F);
            if (tagnum >= 31) {
                ByteArrayInputStream bin = new ByteArrayInputStream(this.comp.encoded, 1, this.comp.encoded.length);
                int[] tagLength = new int[]{0};
                try {
                    Asn1.decodeHighTag(bin, tagLength);
                }
                catch (Asn1Exception e) {
                    // empty catch block
                }
                if (this.tagNum < 31) {
                    this.encoded = new byte[this.comp.encoded.length - tagLength[0]];
                    this.encoded[0] = (byte)(this.classType | this.type | this.tagNum);
                    System.arraycopy(this.comp.encoded, tagLength[0] + 1, this.encoded, 1, this.encoded.length - 1);
                } else {
                    byte[] ourTag = this.encodeHighTag(this.tagNum);
                    int delta = ourTag.length - tagLength[0];
                    this.encoded = new byte[this.comp.encoded.length + delta];
                    this.encoded[0] = (byte)(this.classType | this.type | 0x1F);
                    System.arraycopy(ourTag, 0, this.encoded, 1, ourTag.length);
                    System.arraycopy(this.comp.encoded, 1 + tagLength[0], this.encoded, 1 + ourTag.length, this.encoded.length - 1 - ourTag.length);
                }
            } else if (this.tagNum < 31) {
                this.encoded = this.comp.encoded;
                this.encoded[0] = (byte)(this.classType | this.type | this.tagNum);
            } else {
                byte[] ourTag = this.encodeHighTag(this.tagNum);
                this.encoded = new byte[this.comp.encoded.length + ourTag.length];
                this.encoded[0] = (byte)(this.classType | this.type | 0x1F);
                System.arraycopy(ourTag, 0, this.encoded, 1, ourTag.length);
                System.arraycopy(this.comp.encoded, 1, this.encoded, 1 + ourTag.length, this.comp.encoded.length - 1);
            }
        }
    }

    public int doDecode(int tag, InputStream encoded) throws Asn1Exception {
        return 0;
    }

    public void doEncode(OutputStream encoded) throws IOException {
        this.comp.doEncode(encoded);
    }

    public void doTag(OutputStream encoded) throws IOException {
        if (this.tagNum < 31) {
            encoded.write((byte)(this.classType | this.type | this.tagNum));
        } else {
            encoded.write((byte)(this.classType | this.type | 0x1F));
            encoded.write(this.encodeHighTag(this.tagNum));
        }
    }

    protected int getContentsLen() {
        return this.comp.getContentsLen();
    }
}

