/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Primitive;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.idoox.security.util.RuntimeWrappedException;

public class Asn1String
extends Primitive {
    public Asn1String() {
    }

    public Asn1String(int type, String value) {
        this.tagNum = type;
        try {
            this.contents = value.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public Asn1String(byte[] value) {
        this.tagNum = 4;
        this.contents = value;
    }

    public static Asn1 decode(int tag, InputStream encoded, int[] length) throws Asn1Exception {
        byte tagnum = (byte)(tag & 0x1F);
        Asn1String retval = new Asn1String();
        length[0] = length[0] + ((Asn1)retval).doDecode(tag, encoded);
        retval.tagNum = tagnum;
        return retval;
    }

    public String getString() {
        try {
            return new String(this.contents, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }
}

