/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Primitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Asn1 {
    public static final byte TAG_CLASS_UNIVERSAL = 0;
    public static final byte TAG_CLASS_APPLICATION = 64;
    public static final byte TAG_CLASS_CONTEXT = -128;
    public static final byte TAG_CLASS_PRIVATE = -64;
    public static final byte MASK_CLASS = -64;
    protected static final byte TAG_PRIMITIVE = 0;
    protected static final byte TAG_CONSTRUCTED = 32;
    protected static final byte MASK_CONSTRUCTED = 32;
    public static final byte TAG_BOOLEAN = 1;
    public static final byte TAG_INTEGER = 2;
    public static final byte TAG_BITSTRING = 3;
    public static final byte TAG_OCTETSTRING = 4;
    public static final byte TAG_NULL = 5;
    public static final byte TAG_OID = 6;
    public static final byte TAG_ENUMERATED = 10;
    public static final byte TAG_SEQUENCE = 16;
    public static final byte TAG_SETOF = 17;
    public static final byte TAG_UTF8STRING = 18;
    public static final byte TAG_PRINTABLESTRING = 19;
    public static final byte TAG_T61STRING = 20;
    public static final byte TAG_IA5STRING = 22;
    public static final byte TAG_UTCTIME = 23;
    public static final byte TAG_GENERALIZEDTIME = 24;
    public static final byte TAG_VISIBLESTRING = 26;
    public static final byte TAG_GENERALSTRING = 27;
    public static final byte TAG_BMPSTRING = 30;
    protected static final byte MASK_NUMBER = 31;
    protected int tagNum;
    protected byte classType = 0;
    protected byte[] encoded;
    protected Category dbg = Category.getCategory("com.idoox.security.asn1.Asn1");

    public static Asn1 decode(InputStream encoded) throws Asn1Exception {
        int[] length = new int[]{0};
        return Asn1.decode(encoded, length);
    }

    public static Asn1 decode(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        return Asn1.decode(bin);
    }

    public static Asn1 decode(byte[] encoded, int off, int len) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded, off, len);
        return Asn1.decode(bin);
    }

    public static Asn1 decode(InputStream encoded, int[] length) throws Asn1Exception {
        try {
            byte tag = (byte)encoded.read();
            length[0] = length[0] + 1;
            if ((tag & 0x20) == 32) {
                return Constructed.decode(tag, encoded, length);
            }
            return Primitive.decode(tag, encoded, length);
        }
        catch (IOException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    public int doDecode(InputStream encoded) throws Asn1Exception {
        try {
            int retval = 1;
            byte tag = (byte)encoded.read();
            this.classType = (byte)(tag & 0xFFFFFFC0);
            if ((tag & 0x1F) == 31) {
                int[] intlen = new int[]{0};
                this.tagNum = Asn1.decodeHighTag(encoded, intlen);
                retval += intlen[0];
            } else {
                this.tagNum = tag & 0x1F;
            }
            return retval += this.doDecode(tag, encoded);
        }
        catch (IOException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    public void encode(OutputStream output) throws IOException {
        if (this.encoded != null) {
            output.write(this.encoded);
        } else {
            int len = this.getContentsLen();
            this.doTag(output);
            Asn1.doLength(len, output);
            this.doEncode(output);
        }
    }

    public byte[] encode() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.encode(bout);
            return bout.toByteArray();
        }
        catch (IOException e) {
            this.dbg.info(e.getMessage(), e);
            return null;
        }
    }

    public int getLength() {
        if (this.encoded != null) {
            return this.encoded.length;
        }
        int intLen = this.getContentsLen();
        if (intLen > 127) {
            intLen += Asn1.intToBytes(intLen).length;
        }
        ++intLen;
        ++intLen;
        if (this.tagNum >= 31) {
            intLen += this.encodeHighTag(this.tagNum).length;
        }
        return intLen;
    }

    public void setTagNumber(int num) {
        this.tagNum = num;
    }

    public int getTagNumber() {
        return this.tagNum;
    }

    public void setTagClass(byte cl) {
        this.classType = cl;
    }

    public byte getTagClass() {
        return this.classType;
    }

    public abstract int doDecode(int var1, InputStream var2) throws Asn1Exception;

    public abstract void doEncode(OutputStream var1) throws IOException;

    public abstract void doTag(OutputStream var1) throws IOException;

    protected abstract int getContentsLen();

    private static final void doLength(int in, OutputStream out) throws IOException {
        if (in < 128) {
            out.write(in);
        } else {
            byte[] length = Asn1.intToBytes(in);
            out.write((byte)(length.length | 0x80));
            out.write(length);
        }
    }

    private static final byte[] intToBytes(int in) {
        int length = (Integer.toHexString(in).length() + 1) / 2;
        byte[] bytes = new byte[length];
        int j = 0;
        while (j < length) {
            bytes[j] = (byte)(in >>> 8 * (length - 1 - j) & 0xFF);
            ++j;
        }
        return bytes;
    }

    protected static int decodeLengthOctets(InputStream in, int[] length) throws Asn1Exception {
        try {
            byte firstOct = (byte)in.read();
            length[0] = length[0] + 1;
            if (firstOct == -128) {
                return -1;
            }
            if ((firstOct & 0x80) == 0) {
                if (firstOct == 0) {
                    return 0;
                }
                return firstOct;
            }
            int additional = firstOct & 0x7F;
            length[0] = length[0] + additional;
            return Asn1.bytesToInt(in, additional);
        }
        catch (IOException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    protected static int decodeHighTag(InputStream in, int[] length) throws Asn1Exception {
        try {
            int retval = 0;
            byte b = (byte)in.read();
            if (b == -1) {
                throw new Asn1Exception("End of input stream detected");
            }
            length[0] = length[0] + 1;
            while ((b & 0xFFFFFF80) == -128) {
                retval = retval << 7 | b & 0x7F;
                b = (byte)in.read();
                length[0] = length[0] + 1;
            }
            retval = retval << 7 | b;
            return retval;
        }
        catch (IOException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    protected byte[] encodeHighTag(int tag) {
        byte[] buf = new byte[4];
        int index = 0;
        boolean isFirst = true;
        do {
            buf[index] = (byte)(tag & 0x7F | 0x80);
            if (isFirst) {
                int n = index;
                buf[n] = (byte)(buf[n] & 0x7F);
                isFirst = false;
            }
            ++index;
        } while ((tag >>>= 7) != 0);
        byte[] retval = new byte[index];
        int i = 0;
        while (i < index) {
            retval[i] = buf[index - i - 1];
            ++i;
        }
        return retval;
    }

    protected static final int bytesToInt(InputStream in, int len) throws IOException {
        if (len > 4) {
            throw new IOException("Number of bytes too big");
        }
        byte[] bytes = new byte[len];
        if (in.read(bytes) != len) {
            throw new IOException("Truncated input");
        }
        int retval = 0;
        int j = 0;
        while (j < len) {
            retval = retval << 8 | bytes[j] & 0xFF;
            ++j;
        }
        return retval;
    }
}

