/*
 * Decompiled with CFR 0.152.
 */
package org.xmltrustcenter.verifier;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class X509TrustVerifier
implements TrustVerifier {
    private Set certs = new HashSet();
    private Map certsByEncodedKey = new HashMap();
    private Map certsBySubjectDN = new HashMap();

    private X509TrustVerifier() {
    }

    public X509TrustVerifier(Collection certs) throws GeneralSecurityException {
        this();
        Iterator it = certs.iterator();
        while (it.hasNext()) {
            this.addCert((Certificate)it.next());
        }
    }

    public X509TrustVerifier(KeyStore keyStore) throws GeneralSecurityException, KeyStoreException {
        this();
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.addCert(keyStore.getCertificate(alias));
        }
    }

    public void verifyTrust() throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public synchronized void verifyTrust(PublicKey key) throws TrustVerificationException {
        if (!this.certsByEncodedKey.containsKey(new EncodedKey(key))) {
            throw new TrustVerificationException("Public key is not in the set of trusted certificates");
        }
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        this.verifyTrust(key);
    }

    public synchronized void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        try {
            this.verifyTrust(chain, 0);
        }
        catch (TrustVerificationException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new TrustVerificationException(e);
        }
    }

    private void addCert(Certificate cert) throws GeneralSecurityException {
        X509Certificate xcert = null;
        if (cert instanceof X509Certificate) {
            xcert = (X509Certificate)cert;
        }
        if (xcert != null) {
            xcert.checkValidity();
        }
        this.certs.add(cert);
        PublicKey pk = cert.getPublicKey();
        this.certsByEncodedKey.put(new EncodedKey(pk), cert);
        if (xcert != null) {
            this.certsBySubjectDN.put(xcert.getSubjectDN(), cert);
        }
    }

    private void verifyTrust(Certificate[] certChain, int depth) throws GeneralSecurityException {
        GeneralSecurityException cause_ex = null;
        if (depth >= certChain.length) {
            throw new TrustVerificationException("Certificate chain does not connect to a trusted authority");
        }
        Certificate cert = certChain[depth];
        X509Certificate xcert = null;
        if (cert instanceof X509Certificate) {
            xcert = (X509Certificate)cert;
        }
        if (xcert != null) {
            this.checkX509Certificate(xcert, depth);
        }
        if (this.certs.contains(cert)) {
            return;
        }
        try {
            this.verifyTrust(certChain, depth + 1);
            cert.verify(certChain[depth + 1].getPublicKey());
            this.addCert(cert);
            return;
        }
        catch (GeneralSecurityException ex) {
            cause_ex = ex;
            try {
                X509Certificate signer;
                if (xcert != null && (signer = (X509Certificate)this.certsBySubjectDN.get(xcert.getIssuerDN())) != null) {
                    this.checkX509Certificate(signer, depth + 1);
                    cert.verify(signer.getPublicKey());
                    this.addCert(cert);
                    return;
                }
            }
            catch (GeneralSecurityException ex2) {
                cause_ex = ex2;
            }
            throw cause_ex;
        }
    }

    private void checkX509Certificate(X509Certificate xcert, int depth) throws GeneralSecurityException, TrustVerificationException {
        xcert.checkValidity();
        if (depth > 0) {
            if (xcert.getVersion() < 3) {
                if (!xcert.getSubjectDN().equals(xcert.getIssuerDN())) {
                    throw new TrustVerificationException("Intermediate CA requires v3 certificate, found v" + xcert.getVersion() + " certificate for CA " + depth + " [" + xcert.getSubjectDN().getName() + "]");
                }
            } else if (xcert.getBasicConstraints() < depth - 1) {
                throw new TrustVerificationException("Certificate chain length constraint violated: CA " + depth + " [" + xcert.getSubjectDN().getName() + "] limits path length to " + xcert.getBasicConstraints() + " subordinate intermediate CAs");
            }
        }
    }

    private class EncodedKey {
        byte[] encodedForm;
        int hashCode;

        EncodedKey(Key k) {
            this.encodedForm = k.getEncoded();
            if (this.encodedForm == null) {
                throw new IllegalArgumentException("encodedForm is null");
            }
            this.hashCode = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.hashCode == 0) {
                EncodedKey encodedKey = this;
                synchronized (encodedKey) {
                    if (this.hashCode == 0) {
                        int i = 0;
                        while (i < this.encodedForm.length) {
                            this.hashCode = 31 * this.hashCode + (this.encodedForm[i] & 0xFF);
                            ++i;
                        }
                        if (this.hashCode == 0) {
                            this.hashCode = -1;
                        }
                    }
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof EncodedKey)) {
                return false;
            }
            EncodedKey ek = (EncodedKey)o;
            if (this.encodedForm.length != ek.encodedForm.length) {
                return false;
            }
            int i = 0;
            while (i < this.encodedForm.length) {
                if (this.encodedForm[i] != ek.encodedForm[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

