/*
 * Decompiled with CFR 0.152.
 */
package org.xmltrustcenter.verifier;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.xmltrustcenter.verifier.SSLContextAdapter;
import org.xmltrustcenter.verifier.SSLContextAdapterJDK14;
import org.xmltrustcenter.verifier.SSLContextAdapterJSSE;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class SSLTrustAdapter {
    static final String NO_SSL_MESSAGE = "Neither JSSE nor JDK1.4 are present so SSL is not available";
    static boolean isJDK14Available;
    static boolean isJSSEAvailable;
    private static final Class[] NO_CLASSES;
    private SSLContextAdapter adapter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void verifySession(SSLSession session, TrustVerifier verifier) throws TrustVerificationException, SSLPeerUnverifiedException {
        X509Certificate[] chain = null;
        if (isJDK14Available) {
            chain = (X509Certificate[])session.getPeerCertificates();
        } else {
            if (!isJSSEAvailable) throw new RuntimeException(NO_SSL_MESSAGE);
            javax.security.cert.X509Certificate[] certArray = session.getPeerCertificateChain();
            try {
                if (certArray != null) {
                    chain = SSLContextAdapterJSSE.convertCertificates(certArray);
                }
            }
            catch (Exception e) {
                throw new TrustVerificationException(e);
            }
        }
        if (chain == null) {
            throw new TrustVerificationException();
        }
        verifier.verifyTrust(chain);
    }

    public SSLTrustAdapter(TrustVerifier verifier, int verifierMode) throws GeneralSecurityException {
        this(verifier, verifierMode, (PrivateKey)null, null);
    }

    public SSLTrustAdapter(TrustVerifier verifier, int verifierMode, PrivateKey privateKey, X509Certificate[] certChain) throws GeneralSecurityException {
        if (isJDK14Available) {
            this.adapter = new SSLContextAdapterJDK14(verifier, verifierMode, privateKey, certChain);
        } else if (isJSSEAvailable) {
            this.adapter = new SSLContextAdapterJSSE(verifier, verifierMode, privateKey, certChain);
        } else {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
    }

    public SSLTrustAdapter(TrustVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        if (isJDK14Available) {
            this.adapter = new SSLContextAdapterJDK14(verifier, verifierMode, keyStore, password);
        } else if (isJSSEAvailable) {
            this.adapter = new SSLContextAdapterJSSE(verifier, verifierMode, keyStore, password);
        } else {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
    }

    public SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
        return this.adapter.getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() throws GeneralSecurityException {
        return this.adapter.getServerSocketFactory();
    }

    static {
        NO_SSL_MESSAGE = NO_SSL_MESSAGE;
        isJDK14Available = false;
        isJSSEAvailable = false;
        try {
            Class.forName("javax.net.ssl.HttpsURLConnection");
            isJDK14Available = true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.sun.net.ssl.HttpsURLConnection");
                isJSSEAvailable = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        NO_CLASSES = new Class[0];
    }
}

