/*
 * Decompiled with CFR 0.152.
 */
package org.xmltrustcenter.verifier;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.xmltrustcenter.verifier.SSLContextAdapter;
import org.xmltrustcenter.verifier.SSLContextAdapterJDK14;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

class SSLContextAdapterJSSE
implements SSLContextAdapter {
    private SSLContext context;
    private TrustVerifier verifier;
    private int verifierMode;
    private PrivateKey privateKey;
    private java.security.cert.X509Certificate[] certChain;
    private KeyStore keyStore;
    private String keyStorePassword;

    static java.security.cert.X509Certificate[] convertCertificates(X509Certificate[] oldJSSECerts) throws GeneralSecurityException, CertificateException {
        java.security.cert.X509Certificate[] newCerts = new java.security.cert.X509Certificate[oldJSSECerts.length];
        int i = 0;
        while (i < newCerts.length) {
            byte[] buffer = oldJSSECerts[i].getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            newCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            ++i;
        }
        return newCerts;
    }

    SSLContextAdapterJSSE(TrustVerifier verifier, int verifierMode, PrivateKey privateKey, java.security.cert.X509Certificate[] certChain) throws GeneralSecurityException {
        this.verifier = verifier;
        this.verifierMode = verifierMode;
        this.privateKey = privateKey;
        this.certChain = certChain;
        this.context = SSLContext.getInstance((String)"TLS");
        this.context.init(this.getKeyManagers(), this.getTrustManagers(), null);
    }

    SSLContextAdapterJSSE(TrustVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        this.verifier = verifier;
        this.verifierMode = verifierMode;
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        this.context = SSLContext.getInstance((String)"TLS");
        this.context.init(this.getKeyManagers(), this.getTrustManagers(), null);
    }

    public SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
        return this.context.getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() throws GeneralSecurityException {
        return this.context.getServerSocketFactory();
    }

    private KeyManager[] getKeyManagers() throws GeneralSecurityException {
        if (this.privateKey != null) {
            return new KeyManager[]{new MyKeyManager()};
        }
        if (this.keyStore != null) {
            KeyManagerFactory factory = KeyManagerFactory.getInstance((String)KeyManagerFactory.getDefaultAlgorithm());
            factory.init(this.keyStore, this.keyStorePassword.toCharArray());
            return factory.getKeyManagers();
        }
        return null;
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance((String)TrustManagerFactory.getDefaultAlgorithm());
        factory.init(SSLContextAdapterJDK14.loadCaCerts());
        TrustManager[] managers = factory.getTrustManagers();
        boolean foundX509 = false;
        int i = 0;
        while (i < managers.length) {
            if (managers[i] instanceof X509TrustManager) {
                managers[i] = new MyTrustManager((X509TrustManager)managers[i]);
                foundX509 = true;
                break;
            }
            ++i;
        }
        if (!foundX509) {
            throw new RuntimeException("No default X509TrustManager available");
        }
        return managers;
    }

    static void disableHostnameVerification(HttpsURLConnection conn) {
        conn.setHostnameVerifier((HostnameVerifier)new NullHostnameVerifier());
    }

    static class NullHostnameVerifier
    implements HostnameVerifier {
        NullHostnameVerifier() {
        }

        public boolean verify(String urlHost, String certHost) {
            return true;
        }
    }

    private class MyKeyManager
    implements X509KeyManager {
        private MyKeyManager() {
        }

        public String chooseClientAlias(String keyType, Principal[] issuers) {
            return "OneAndOnly";
        }

        public String chooseServerAlias(String keyType, Principal[] issuers) {
            return "OneAndOnly";
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return SSLContextAdapter.ALIASES;
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return SSLContextAdapter.ALIASES;
        }

        public java.security.cert.X509Certificate[] getCertificateChain(String alias) {
            if ("OneAndOnly".equals(alias)) {
                return SSLContextAdapterJSSE.this.certChain;
            }
            return null;
        }

        public PrivateKey getPrivateKey(String alias) {
            if ("OneAndOnly".equals(alias)) {
                return SSLContextAdapterJSSE.this.privateKey;
            }
            return null;
        }
    }

    private class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager baseManager;

        private MyTrustManager(X509TrustManager baseManager) {
            this.baseManager = baseManager;
        }

        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return this.baseManager.getAcceptedIssuers();
        }

        public boolean isClientTrusted(java.security.cert.X509Certificate[] chain) {
            if (SSLContextAdapterJSSE.this.verifier != null) {
                switch (SSLContextAdapterJSSE.this.verifierMode) {
                    case 0: {
                        return this.isVerified(chain) || this.baseManager.isClientTrusted(chain);
                    }
                    case 1: {
                        return this.isVerified(chain) && this.baseManager.isClientTrusted(chain);
                    }
                    case 2: {
                        return this.isVerified(chain);
                    }
                }
                throw new IllegalArgumentException("Unknown verifierMode: " + SSLContextAdapterJSSE.this.verifierMode);
            }
            return this.baseManager.isClientTrusted(chain);
        }

        public boolean isServerTrusted(java.security.cert.X509Certificate[] chain) {
            if (SSLContextAdapterJSSE.this.verifier != null) {
                switch (SSLContextAdapterJSSE.this.verifierMode) {
                    case 0: {
                        return this.isVerified(chain) || this.baseManager.isServerTrusted(chain);
                    }
                    case 1: {
                        return this.isVerified(chain) && this.baseManager.isServerTrusted(chain);
                    }
                    case 2: {
                        return this.isVerified(chain);
                    }
                }
                throw new IllegalArgumentException("Unknown verifierMode: " + SSLContextAdapterJSSE.this.verifierMode);
            }
            return this.baseManager.isServerTrusted(chain);
        }

        private boolean isVerified(java.security.cert.X509Certificate[] chain) {
            try {
                SSLContextAdapterJSSE.this.verifier.verifyTrust(chain);
                return true;
            }
            catch (TrustVerificationException e) {
                return false;
            }
        }
    }
}

