/*
 * Decompiled with CFR 0.152.
 */
package org.xmltrustcenter.verifier;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.xmltrustcenter.verifier.SSLContextAdapter;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

class SSLContextAdapterJDK14
implements SSLContextAdapter {
    private SSLContext context;
    private TrustVerifier verifier;
    private int verifierMode;
    private PrivateKey privateKey;
    private X509Certificate[] certChain;
    private KeyStore keyStore;
    private String keyStorePassword;

    SSLContextAdapterJDK14(TrustVerifier verifier, int verifierMode, PrivateKey privateKey, X509Certificate[] certChain) throws GeneralSecurityException {
        this.verifier = verifier;
        this.verifierMode = verifierMode;
        this.privateKey = privateKey;
        this.certChain = certChain;
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.getKeyManagers(), this.getTrustManagers(), null);
    }

    SSLContextAdapterJDK14(TrustVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        this.verifier = verifier;
        this.verifierMode = verifierMode;
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.getKeyManagers(), this.getTrustManagers(), null);
    }

    public SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
        return this.context.getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() throws GeneralSecurityException {
        return this.context.getServerSocketFactory();
    }

    private KeyManager[] getKeyManagers() throws GeneralSecurityException {
        if (this.privateKey != null) {
            return new KeyManager[]{new MyKeyManager()};
        }
        if (this.keyStore != null) {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(this.keyStore, this.keyStorePassword.toCharArray());
            return factory.getKeyManagers();
        }
        return null;
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(SSLContextAdapterJDK14.loadCaCerts());
        TrustManager[] managers = factory.getTrustManagers();
        boolean foundX509 = false;
        int i = 0;
        while (i < managers.length) {
            if (managers[i] instanceof X509TrustManager) {
                managers[i] = new MyTrustManager((X509TrustManager)managers[i]);
                foundX509 = true;
                break;
            }
            ++i;
        }
        if (!foundX509) {
            throw new RuntimeException("No default X509TrustManager available");
        }
        return managers;
    }

    static KeyStore loadCaCerts() throws GeneralSecurityException {
        try {
            KeyStore ks = KeyStore.getInstance("JKS", "SUN");
            String fname = System.getProperty("java.home") + "/lib/security/cacerts";
            FileInputStream fis = new FileInputStream(fname);
            ks.load(new BufferedInputStream(fis), null);
            fis.close();
            return ks;
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e.toString());
        }
    }

    static void disableHostnameVerification(HttpsURLConnection conn) {
        conn.setHostnameVerifier(new NullHostnameVerifier());
    }

    private static class NullHostnameVerifier
    implements HostnameVerifier {
        private NullHostnameVerifier() {
        }

        public boolean verify(String host, SSLSession s) {
            return true;
        }
    }

    private class MyKeyManager
    implements X509KeyManager {
        private MyKeyManager() {
        }

        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return "OneAndOnly";
        }

        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return "OneAndOnly";
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return SSLContextAdapter.ALIASES;
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return SSLContextAdapter.ALIASES;
        }

        public X509Certificate[] getCertificateChain(String alias) {
            if ("OneAndOnly".equals(alias)) {
                return SSLContextAdapterJDK14.this.certChain;
            }
            return null;
        }

        public PrivateKey getPrivateKey(String alias) {
            if ("OneAndOnly".equals(alias)) {
                return SSLContextAdapterJDK14.this.privateKey;
            }
            return null;
        }
    }

    private class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager baseManager;

        private MyTrustManager(X509TrustManager baseManager) {
            this.baseManager = baseManager;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.baseManager.getAcceptedIssuers();
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block8: {
                block7: {
                    if (SSLContextAdapterJDK14.this.verifier == null) break block7;
                    switch (SSLContextAdapterJDK14.this.verifierMode) {
                        case 0: {
                            try {
                                this.checkVerified(chain);
                            }
                            catch (CertificateException e) {
                                this.baseManager.checkClientTrusted(chain, authType);
                            }
                            break block8;
                        }
                        case 1: {
                            this.checkVerified(chain);
                            this.baseManager.checkClientTrusted(chain, authType);
                            break block8;
                        }
                        case 2: {
                            this.checkVerified(chain);
                            break block8;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown verifierMode: " + SSLContextAdapterJDK14.this.verifierMode);
                        }
                    }
                }
                this.baseManager.checkClientTrusted(chain, authType);
            }
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block8: {
                block7: {
                    if (SSLContextAdapterJDK14.this.verifier == null) break block7;
                    switch (SSLContextAdapterJDK14.this.verifierMode) {
                        case 0: {
                            try {
                                this.checkVerified(chain);
                            }
                            catch (CertificateException e) {
                                this.baseManager.checkServerTrusted(chain, authType);
                            }
                            break block8;
                        }
                        case 1: {
                            this.checkVerified(chain);
                            this.baseManager.checkServerTrusted(chain, authType);
                            break block8;
                        }
                        case 2: {
                            this.checkVerified(chain);
                            break block8;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown verifierMode: " + SSLContextAdapterJDK14.this.verifierMode);
                        }
                    }
                }
                this.baseManager.checkServerTrusted(chain, authType);
            }
        }

        private void checkVerified(X509Certificate[] chain) throws CertificateException {
            try {
                SSLContextAdapterJDK14.this.verifier.verifyTrust(chain);
            }
            catch (TrustVerificationException e) {
                throw new CertificateException(e.toString());
            }
        }
    }
}

