/*
 * Decompiled with CFR 0.152.
 */
package org.xmltrustcenter.verifier;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class NotifyingTrustVerifier
implements TrustVerifier {
    private TrustVerifier verifier;

    public NotifyingTrustVerifier(TrustVerifier verifier) {
        this.verifier = verifier;
    }

    public void verifyTrust() throws TrustVerificationException {
        try {
            this.verifier.verifyTrust();
            this.notify(null, null, null, null);
        }
        catch (TrustVerificationException e) {
            this.notify(null, null, null, e);
            throw e;
        }
    }

    public void verifyTrust(PublicKey key) throws TrustVerificationException {
        try {
            this.verifier.verifyTrust(key);
            this.notify(null, key, null, null);
        }
        catch (TrustVerificationException e) {
            this.notify(null, key, null, e);
            throw e;
        }
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        try {
            this.verifier.verifyTrust(key, keyName);
            this.notify(null, key, keyName, null);
        }
        catch (TrustVerificationException e) {
            this.notify(null, key, keyName, e);
            throw e;
        }
    }

    public void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        try {
            this.verifier.verifyTrust(chain);
            this.notify(chain, null, null, null);
        }
        catch (TrustVerificationException e) {
            this.notify(chain, null, null, e);
            throw e;
        }
    }

    protected void notify(X509Certificate[] chain, PublicKey key, String keyName, TrustVerificationException e) {
    }
}

