/*
 * Decompiled with CFR 0.152.
 */
package org.xmltrustcenter.verifier;

import java.io.PrintStream;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.xmltrustcenter.verifier.NotifyingTrustVerifier;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class LoggingTrustVerifier
extends NotifyingTrustVerifier {
    private static int logCounter = 0;
    private PrintStream log;

    public LoggingTrustVerifier(TrustVerifier verifier, PrintStream log) {
        super(verifier);
        this.log = log;
    }

    protected void notify(X509Certificate[] chain, PublicKey key, String keyName, TrustVerificationException e) {
        if (logCounter == 0) {
            this.log.println("------------------------------------------------");
        }
        X509Certificate cert = chain != null && chain.length > 0 ? chain[0] : null;
        this.log.println("Trust Verification #" + ++logCounter + ' ' + (e != null ? "failed" : "passed") + ' ' + new Date());
        if (cert != null) {
            this.log.println();
            this.log.println("Certificate: " + cert);
        }
        if (key != null) {
            this.log.println();
            this.log.println("Public Key: " + key);
        }
        if (keyName != null) {
            this.log.println();
            this.log.println("Key Name [: " + keyName + ']');
        }
        if (e != null) {
            this.log.println();
            this.log.println("Exception [: " + e + ']');
        }
        this.log.println("------------------------------------------------");
    }
}

