/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xpath;

import com.verisign.xpath.IDDiscriminator;
import com.verisign.xpath.SimpleIDDiscriminator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XPath {
    public static final XPath DOCUMENT_ROOT = new XPath("/");
    public static final XPath DOCUMENT_ELEMENT = new XPath("/*");
    private static final String XPOINTER_PREFIX = "#xpointer(";
    private static final char XPOINTER_SUFFIX = ')';
    private static IDDiscriminator defaultIDDiscriminator;
    private Map map;
    private String exprString;
    private IDDiscriminator idDiscriminator = defaultIDDiscriminator;

    public XPath(String expr) {
        this.map = new HashMap();
        this.setXPath(expr);
    }

    public XPath(String expr, String[] namespaces) {
        this.map = new HashMap();
        this.setXPath(expr);
        this.addNamespace(namespaces);
    }

    public XPath(String expr, Map namespaces) {
        if (namespaces == null) {
            namespaces = new HashMap();
        }
        this.setXPath(expr);
        this.map = namespaces;
    }

    private void addNamespace(String[] namespaces) {
        int i = 0;
        while (i < namespaces.length) {
            this.addNamespace(namespaces[i], namespaces[i + 1]);
            i += 2;
        }
    }

    public void setXPath(String expr) {
        this.exprString = expr;
    }

    public static XPath fromID(String idValue) {
        XPath xpath = new XPath(null);
        xpath.setIdXPath(idValue);
        return xpath;
    }

    public String toID() {
        char q;
        if (this.exprString == null) {
            return null;
        }
        int len = this.exprString.length();
        if (len > 6 && this.exprString.startsWith("id(") && this.exprString.charAt(len - 1) == ')' && ((q = this.exprString.charAt(3)) == '\"' || q == '\'') && q == this.exprString.charAt(len - 2)) {
            return this.exprString.substring(4, len - 2);
        }
        return null;
    }

    public void setIdXPath(String idValue) {
        this.exprString = "id('" + idValue + "')";
    }

    public static XPath fromXPointer(String xpointer) {
        return XPath.fromXPointer(xpointer, null);
    }

    public static XPath fromXPointer(String xpointer, Map namespaces) {
        if (xpointer.startsWith(XPOINTER_PREFIX) && xpointer.length() > XPOINTER_PREFIX.length() + 1 && xpointer.charAt(xpointer.length() - 1) == ')') {
            return new XPath(xpointer.substring(XPOINTER_PREFIX.length(), xpointer.length() - 1), namespaces);
        }
        XPath xpath = new XPath(null);
        if (xpointer.length() > 1) {
            xpath.setIdXPath(xpointer.substring(1));
        }
        return xpath;
    }

    public String toXPointer() {
        if (this.exprString == null) {
            return null;
        }
        String idValue = this.toID();
        if (idValue != null) {
            return "#" + idValue;
        }
        return XPOINTER_PREFIX + this.exprString + ')';
    }

    public String getXPath() {
        return this.exprString;
    }

    public void addNamespace(String prefix, String uri) {
        this.map.put(prefix, uri);
    }

    public String[] getNamespaces() {
        Iterator entries = this.map.entrySet().iterator();
        String[] s = new String[this.map.size() * 2];
        int i = 0;
        while (entries.hasNext()) {
            Map.Entry e = entries.next();
            String prefix = (String)e.getKey();
            String uri = (String)e.getValue();
            s[i] = prefix;
            s[i + 1] = uri;
            i += 2;
        }
        return s;
    }

    public Map getNamespaceMap() {
        return this.map;
    }

    public static IDDiscriminator getDefaultIDDiscriminator() {
        return defaultIDDiscriminator;
    }

    public static void setDefaultIDDiscriminator(IDDiscriminator idDiscriminator) {
        if (idDiscriminator == null) {
            throw new IllegalArgumentException("idDiscriminator is null");
        }
        defaultIDDiscriminator = idDiscriminator;
    }

    public IDDiscriminator getIDDiscriminator() {
        return this.idDiscriminator;
    }

    public void setIDDiscriminator(IDDiscriminator idDiscriminator) {
        if (idDiscriminator == null) {
            throw new IllegalArgumentException("idDiscriminator is null");
        }
        this.idDiscriminator = idDiscriminator;
    }

    public String toString() {
        return this.exprString;
    }

    static {
        XPOINTER_PREFIX = XPOINTER_PREFIX;
        XPOINTER_SUFFIX = (char)41;
        defaultIDDiscriminator = new SimpleIDDiscriminator();
    }
}

