/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.tools;

import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.util.Debug;
import com.verisign.xmlsig.tools.KeyConverter;
import com.verisign.xpath.XPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Enumeration;

public class PrivateKeyTool {
    private static boolean DEBUG = false;
    private static String keyStorePassword;
    private static KeyStore ks;
    static /* synthetic */ Class class$com$verisign$xmlsig$tools$PrivateKeyTool;

    private static void readKeystore(String keyStoreName) throws Exception {
        File keyStoreFile = new File(keyStoreName);
        if (keyStoreFile.exists()) {
            FileInputStream fis = new FileInputStream(keyStoreFile);
            PrivateKeyTool.dbg(3, "reading jks keystore in " + keyStoreName);
            ks = KeyStore.getInstance("JKS");
            ks.load(fis, keyStorePassword.toCharArray());
        } else {
            PrivateKeyTool.dbg(3, "creating new keystore (" + keyStoreName + " not found)");
            ks = KeyStore.getInstance("JKS");
            ks.load(null, keyStorePassword.toCharArray());
        }
    }

    private static void writeKeystore(String keyStoreName) throws Exception {
        File keyStoreFile = new File(keyStoreName);
        FileOutputStream fos = new FileOutputStream(keyStoreFile);
        ks.store(fos, keyStorePassword.toCharArray());
    }

    public static void main(String[] argv) {
        try {
            if (PrivateKeyTool.findFlag("-?", argv) || PrivateKeyTool.findFlag("-h", argv) || PrivateKeyTool.findFlag("-help", argv)) {
                PrivateKeyTool.printHelp();
                System.exit(1);
            }
            if (PrivateKeyTool.findFlag("-v", argv)) {
                Debug.setLevel(2);
                Debug.setPrintStream(System.err);
            }
            if (PrivateKeyTool.findFlag("-vv", argv)) {
                Debug.setLevel(3);
                Debug.setPrintStream(System.err);
                Debug.out("Setting maximum debug output", 3);
            }
            String keyStoreName = PrivateKeyTool.findValue("-keystore", argv);
            keyStorePassword = PrivateKeyTool.findValue(true, "-storepass", argv);
            if (keyStoreName == null) {
                keyStoreName = System.getProperty("user.home") + "/.keystore";
            }
            if (argv.length >= 1 && argv[0].equals("-importp12")) {
                PrivateKeyTool.readKeystore(keyStoreName);
                PrivateKeyTool.importPkcs12(argv);
            } else if (argv.length >= 1 && argv[0].equals("-importp8")) {
                PrivateKeyTool.readKeystore(keyStoreName);
                PrivateKeyTool.importPkcs8(argv);
            } else if (argv.length >= 1 && argv[0].equals("-exportp8")) {
                PrivateKeyTool.readKeystore(keyStoreName);
                PrivateKeyTool.exportPkcs8(argv);
            } else {
                PrivateKeyTool.printHelp();
                System.exit(1);
            }
            PrivateKeyTool.writeKeystore(keyStoreName);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            } else {
                System.out.println(e.toString());
            }
            System.exit(1);
        }
    }

    private static void printHelp() {
        PrintStream p = System.err;
        p.println("For all commands, keystore defaults to .keystore in ");
        p.println("user's home directory.\n");
        p.println("java " + (class$com$verisign$xmlsig$tools$PrivateKeyTool == null ? (class$com$verisign$xmlsig$tools$PrivateKeyTool = PrivateKeyTool.class$("com.verisign.xmlsig.tools.PrivateKeyTool")) : class$com$verisign$xmlsig$tools$PrivateKeyTool).getName() + " usage:\n");
        p.println("-importp12   [-keystore <string>] -storepass<string>");
        p.println("              -file <string>      -p12password <string>");
        p.println("              -password <string> [-alias <string>]\n");
        p.println("  where alias defaults to alias found in PKCS#12 file.\n");
        p.println("-importp8   [-keystore <string>] -storepass<string>");
        p.println("             -keyfile <string>   -certfile <string>");
        p.println("             -password <string>  -alias <string>\n");
        p.println("-exportp8   [-keystore <string>] -storepass<string>");
        p.println("             -keyfile <string>   -password <string>");
        p.println("             -alias <string>\n");
    }

    private static void importPkcs8(String[] argv) throws Exception {
        String keyFileName = PrivateKeyTool.findValue(true, "-keyfile", argv);
        String certFileName = PrivateKeyTool.findValue(true, "-certfile", argv);
        String password = PrivateKeyTool.findValue(true, "-password", argv);
        String alias = PrivateKeyTool.findValue(true, "-alias", argv);
        PrivateKey key = (PrivateKey)PrivateKeyTool.readKey(keyFileName);
        Certificate[] certs = PrivateKeyTool.readCert(certFileName);
        ks.setKeyEntry(alias, key, password.toCharArray(), certs);
    }

    private static void exportPkcs8(String[] argv) throws Exception {
        String password;
        String keyFileName = PrivateKeyTool.findValue(true, "-keyfile", argv);
        String alias = PrivateKeyTool.findValue(true, "-alias", argv);
        Key key = ks.getKey(alias, (password = PrivateKeyTool.findValue(true, "-password", argv)).toCharArray());
        if (!"PKCS8".equals(key.getFormat())) {
            throw new IllegalArgumentException("Key is not exportable in PKCS #8 format (found " + key.getFormat() + " format)");
        }
        FileOutputStream fos = new FileOutputStream(keyFileName);
        fos.write(key.getEncoded());
        fos.close();
    }

    private static void importPkcs12(String[] argv) throws Exception {
        String p12FileName = PrivateKeyTool.findValue(true, "-file", argv);
        String p12Password = PrivateKeyTool.findValue(true, "-p12password", argv);
        String password = PrivateKeyTool.findValue(true, "-password", argv);
        String alias = PrivateKeyTool.findValue("-alias", argv);
        KeyStore p12KeyStore = KeyStore.getInstance("PKCS12");
        FileInputStream is = new FileInputStream(new File(p12FileName));
        p12KeyStore.load(is, p12Password.toCharArray());
        is.close();
        Enumeration<String> p12Aliases = p12KeyStore.aliases();
        if (!p12Aliases.hasMoreElements()) {
            throw new IllegalArgumentException("pkcs12 file is empty: " + p12FileName);
        }
        String p12Alias = p12Aliases.nextElement();
        if (p12Aliases.hasMoreElements()) {
            throw new IllegalArgumentException("pkcs12 file has more than one entry: " + p12FileName);
        }
        if (alias == null) {
            alias = p12Alias;
        }
        if (p12KeyStore.isCertificateEntry(p12Alias)) {
            Certificate cert = p12KeyStore.getCertificate(p12Alias);
            ks.setCertificateEntry(alias, cert);
        } else if (p12KeyStore.isKeyEntry(p12Alias)) {
            Key key = p12KeyStore.getKey(p12Alias, p12Password.toCharArray());
            Certificate[] chain = p12KeyStore.getCertificateChain(p12Alias);
            ks.setKeyEntry(alias, key, password.toCharArray(), chain);
        }
    }

    private static Certificate[] readCert(String filename) throws Exception {
        FileInputStream fis = new FileInputStream(filename);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> c = cf.generateCertificates(fis);
        fis.close();
        return c.toArray(new Certificate[0]);
    }

    private static Key readKey(String filename) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream p = new ObjectInputStream(fis);
            RSAPrivateKey key = (RSAPrivateKey)p.readObject();
            fis.close();
            return key;
        }
        catch (StreamCorruptedException e) {
            try {
                PrivateKeyTool.dbg(3, filename + " is not a serialized key.");
                PrivateKeyTool.dbg(3, "Converting XML to java key");
                XMLResource xmlres = ResourceFactory.getXMLResource();
                FileInputStream fis = new FileInputStream(filename);
                return (RSAPrivateKey)KeyConverter.keyInfoToPrivateKey(xmlres.parseXML(fis, false), new XPath("/"));
            }
            catch (IOException ex) {
                PrivateKeyTool.dbg(3, filename + " is not an XML key.");
                PrivateKeyTool.dbg(3, "Converting PKCS#8 to java key");
                FileInputStream fis = new FileInputStream(filename);
                byte[] b = new byte[fis.available()];
                fis.read(b);
                fis.close();
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(b);
                KeyFactory keyFactory = KeyFactory.getInstance("rsa");
                return keyFactory.generatePrivate(spec);
            }
        }
    }

    private static void dbg(int level, String s) {
        Debug.out("[PrivateKeyTool] " + s, level);
    }

    private static String findValue(String toFind, String[] argv) {
        return PrivateKeyTool.findValue(false, toFind, argv);
    }

    private static String findValue(boolean required, String toFind, String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals(toFind)) {
                String s = PrivateKeyTool.nextArgv(argv, i);
                PrivateKeyTool.dbg(4, "Argument: " + toFind + "=" + s);
                return s;
            }
            ++i;
        }
        if (required) {
            throw new IllegalArgumentException("'" + toFind + "' argument missing in input");
        }
        return null;
    }

    private static boolean findFlag(String toFind, String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals(toFind)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String nextArgv(String[] argv, int i) {
        if (argv[i + 1] != null && !argv[i + 1].startsWith("-")) {
            return argv[i + 1];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ks = null;
    }
}

