/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.tools;

import com.verisign.datatypes.Base64;
import com.verisign.digsig.keys.X509Data;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.xmlsig.elements.DSAKeyValue;
import com.verisign.xmlsig.util.Helper;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyConverter {
    private static boolean DEBUG = false;
    private static final String DIGSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    private static final String DIGSIG_PREFIX = "ds";
    private static final String XKMS_NS = "http://www.xkms.org/schema/xkms-2001-01-20";
    private static final String XKMS_PREFIX = "xkms";
    private static final XMLResource xmlres;

    private KeyConverter() {
    }

    public static PublicKey keyInfoToPublicKey(Document doc, XPath xpath) throws GeneralSecurityException, XPathException {
        DOMCursor c = new DOMCursor(doc);
        if (!c.moveToXPath(xpath)) {
            return null;
        }
        if (DSAKeyValue.isAnElementIn(c)) {
            DSAKeyValue dsaKey = DSAKeyValue.fromXml(c);
            return dsaKey.generateDsaPublicKey();
        }
        XKeyInfo keyInfo = KeyConverter.toXKeyInfo(doc, xpath);
        try {
            return keyInfo.getAsPublicKey();
        }
        catch (InvalidKeySpecException ikspe) {
            throw new InvalidKeyException(ikspe.toString());
        }
    }

    public static PrivateKey keyInfoToPrivateKey(Document doc, XPath xpath) throws GeneralSecurityException, XPathException {
        PrivateKey key = KeyConverter.xkmsKeyInfoToPrivateKey(doc, xpath);
        if (key == null) {
            XKeyInfo keyInfo = KeyConverter.toXKeyInfo(doc, xpath);
            try {
                key = keyInfo.getAsPrivateKey();
            }
            catch (InvalidKeySpecException ikspe) {
                throw new InvalidKeyException(ikspe.toString());
            }
        }
        return key;
    }

    private static XKeyInfo toXKeyInfo(Document doc, XPath xpath) throws XPathException {
        DOMCursor c = new DOMCursor(doc);
        if (!c.moveToXPath(xpath)) {
            throw new XPathException("'" + xpath.getXPath() + "'" + " evaluates to nothing");
        }
        if (DEBUG) {
            Helper.dump(null, "keyInfoToPublicKey()", c.getElement());
        }
        return new XKeyInfo(c.getElement());
    }

    public static Document publicKeyToKeyInfo(PublicKey key) {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        if (key instanceof DSAPublicKey) {
            DSAKeyValue dk = new DSAKeyValue((DSAPublicKey)key);
            DOMWriteCursor cursor = new DOMWriteCursor();
            dk.toXml(cursor);
            return cursor.getDocument();
        }
        XRSAKeyValue pubkval = new XRSAKeyValue(doc, (RSAKey)((Object)key));
        XKeyInfo keyInfo = new XKeyInfo(doc);
        keyInfo.setKeyName("Public Key");
        keyInfo.setKeyValue(pubkval);
        Element e = keyInfo.getElement();
        Node n = doc.importNode(e, true);
        doc.appendChild(n);
        return doc;
    }

    public static Document privateKeyToKeyInfo(PrivateKey key) {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        if (key instanceof DSAPrivateKey) {
            DSAKeyValue dk = new DSAKeyValue((DSAPrivateKey)key);
            DOMWriteCursor cursor = new DOMWriteCursor(doc);
            dk.toXml(cursor);
            return doc;
        }
        return KeyConverter.privateKeyToXkmsKeyInfo(key);
    }

    private static Document privateKeyToOldKeyInfo(PrivateKey key) {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        XRSAKeyValue xRSAKeyValue = new XRSAKeyValue(doc, (RSAPrivateKey)key);
        XKeyInfo xkeyInfo = new XKeyInfo(doc);
        xkeyInfo.setKeyName("Private Key");
        xkeyInfo.setKeyValue(xRSAKeyValue);
        Element e = xkeyInfo.getElement();
        Node n = doc.importNode(e, true);
        doc.appendChild(n);
        return doc;
    }

    public static X509Certificate keyInfoToCertificate(Document doc, XPath xpath) throws GeneralSecurityException, XPathException {
        XKeyInfo keyInfo = KeyConverter.toXKeyInfo(doc, xpath);
        Enumeration x509Enum = keyInfo.enumX509Data();
        if (x509Enum != null && x509Enum.hasMoreElements()) {
            X509Data x509 = (X509Data)x509Enum.nextElement();
            return x509.getCertificate();
        }
        return null;
    }

    public static Document certificateToKeyInfo(X509Certificate cert) throws GeneralSecurityException, XPathException {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        X509Data x509 = new X509Data(cert);
        XKeyInfo xkeyInfo = x509.makeKeyInfo(null);
        Element e = xkeyInfo.getElement();
        Node n = doc.importNode(e, true);
        doc.appendChild(n);
        return doc;
    }

    private static Document privateKeyToXkmsKeyInfo(PrivateKey key) {
        RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)key;
        DOMWriteCursor c = new DOMWriteCursor();
        c = c.addUnder(DIGSIG_NS, DIGSIG_PREFIX, "KeyInfo");
        c = c.addUnder(DIGSIG_NS, DIGSIG_PREFIX, "KeyValue");
        c = c.addUnder(XKMS_NS, XKMS_PREFIX, "RSAKeyPair");
        DOMWriteCursor c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "Modulus");
        KeyConverter.setBigInt(c2, crtKey.getModulus());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "PublicExponent");
        KeyConverter.setBigInt(c2, crtKey.getPublicExponent());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "PrivateExponent");
        KeyConverter.setBigInt(c2, crtKey.getPrivateExponent());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "P");
        KeyConverter.setBigInt(c2, crtKey.getPrimeP());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "Q");
        KeyConverter.setBigInt(c2, crtKey.getPrimeQ());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "DP");
        KeyConverter.setBigInt(c2, crtKey.getPrimeExponentP());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "DQ");
        KeyConverter.setBigInt(c2, crtKey.getPrimeExponentQ());
        c2 = c.addUnder(XKMS_NS, XKMS_PREFIX, "QINV");
        KeyConverter.setBigInt(c2, crtKey.getCrtCoefficient());
        return c.getDocument();
    }

    private static PrivateKey xkmsKeyInfoToPrivateKey(Document doc, XPath xpath) throws GeneralSecurityException, XPathException {
        DOMCursor c = new DOMCursor(doc);
        if (!c.moveToXPath(xpath)) {
            return null;
        }
        if (DSAKeyValue.isAnElementIn(c)) {
            DSAKeyValue dsaKey = DSAKeyValue.fromXml(c);
            return dsaKey.generateDsaPrivateKey();
        }
        XPath kpXPath = new XPath("ds:KeyValue/xkms:RSAKeyPair", new String[]{DIGSIG_PREFIX, DIGSIG_NS, XKMS_PREFIX, XKMS_NS});
        if (!c.moveToXPath(kpXPath)) {
            return null;
        }
        BigInteger modulus = null;
        BigInteger pubE = null;
        BigInteger privE = null;
        BigInteger p = null;
        BigInteger q = null;
        BigInteger dp = null;
        BigInteger dq = null;
        BigInteger qinv = null;
        boolean more = c.moveToChild(1);
        while (more) {
            if (c.atElement(XKMS_NS, "Modulus")) {
                modulus = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "PublicExponent")) {
                pubE = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "PrivateExponent")) {
                privE = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "P")) {
                p = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "Q")) {
                q = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "DP")) {
                dp = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "DQ")) {
                dq = KeyConverter.getBigInt(c);
            } else if (c.atElement(XKMS_NS, "QINV")) {
                qinv = KeyConverter.getBigInt(c);
            } else {
                throw new InvalidKeyException("Unknown element at " + c);
            }
            more = c.moveToSibling(1);
        }
        if (modulus == null || pubE == null || privE == null || p == null || q == null || dp == null || dq == null || qinv == null) {
            throw new InvalidKeyException("Require all private key elements: Modulus, PublicExponent, PrivateExponent, P, Q, DP, DQ, QINV");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("rsa");
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(modulus, pubE, privE, p, q, dp, dq, qinv);
        return keyFactory.generatePrivate(spec);
    }

    private static BigInteger getBigInt(DOMCursor c) throws InvalidKeyException {
        String text = c.getText();
        if (text.length() == 0) {
            throw new InvalidKeyException("Empty value at " + c);
        }
        return new BigInteger(Base64.decode(text));
    }

    private static void setBigInt(DOMWriteCursor c, BigInteger val) {
        c.setText(Base64.encode(val.toByteArray()));
    }

    private static void usage() {
        System.err.println("usage: java com.verisign.xmlsig.tools.KeyConverter\n   pr2k Pkcs8Private    > KeyInfo\n | pu2k X509Public      > KeyInfo\n | c2k  X509Cert        > KeyInfo\n | k2pr KeyInfo [XPath] > Pkcs8Private\n | k2pu KeyInfo [XPath] > X509Public\n | k2c  KeyInfo [XPath] > X509Cert");
        System.exit(2);
    }

    public static void main(String[] argv) {
        block19: {
            if (argv.length < 2) {
                KeyConverter.usage();
            }
            try {
                String cmd = argv[0];
                FileInputStream istream = new FileInputStream(argv[1]);
                XPath xpath = new XPath(argv.length > 2 ? argv[2] : "/*");
                PrintStream out = System.out;
                if (cmd.equals("pr2k")) {
                    PrivateKey prk;
                    byte[] buf = new byte[istream.available()];
                    istream.read(buf);
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(buf);
                    try {
                        KeyFactory keyFactory = KeyFactory.getInstance("rsa");
                        prk = keyFactory.generatePrivate(spec);
                    }
                    catch (InvalidKeySpecException e) {
                        KeyFactory keyFactory = KeyFactory.getInstance("dsa");
                        prk = keyFactory.generatePrivate(spec);
                    }
                    istream.close();
                    Document d = KeyConverter.privateKeyToKeyInfo(prk);
                    xmlres.publish(d, (OutputStream)out);
                    break block19;
                }
                if (cmd.equals("pr2ok")) {
                    byte[] buf = new byte[istream.available()];
                    istream.read(buf);
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(buf);
                    KeyFactory keyFactory = KeyFactory.getInstance("rsa");
                    PrivateKey prk = keyFactory.generatePrivate(spec);
                    istream.close();
                    Document d = KeyConverter.privateKeyToOldKeyInfo(prk);
                    xmlres.publish(d, (OutputStream)out);
                    break block19;
                }
                if (cmd.equals("pu2k")) {
                    PublicKey puk;
                    byte[] buf = new byte[istream.available()];
                    istream.read(buf);
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(buf);
                    try {
                        KeyFactory keyFactory = KeyFactory.getInstance("rsa");
                        puk = keyFactory.generatePublic(spec);
                    }
                    catch (InvalidKeySpecException e) {
                        KeyFactory keyFactory = KeyFactory.getInstance("dsa");
                        puk = keyFactory.generatePublic(spec);
                    }
                    istream.close();
                    Document d = KeyConverter.publicKeyToKeyInfo(puk);
                    xmlres.publish(d, (OutputStream)out);
                    break block19;
                }
                if (cmd.equals("k2pu")) {
                    Document doc = xmlres.parseXML(istream, false);
                    PublicKey pubKey = KeyConverter.keyInfoToPublicKey(doc, xpath);
                    out.write(pubKey.getEncoded());
                    break block19;
                }
                if (cmd.equals("k2pr")) {
                    Document doc = xmlres.parseXML(istream, false);
                    PrivateKey privKey = KeyConverter.keyInfoToPrivateKey(doc, xpath);
                    try {
                        byte[] buf = privKey.getEncoded();
                        if (buf != null) {
                            out.write(buf);
                            break block19;
                        }
                        System.err.println("Can't get encoded private key");
                    }
                    catch (Exception e) {
                        System.err.println("Can't get encoded private key: " + e);
                    }
                    break block19;
                }
                if (cmd.equals("c2k")) {
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)factory.generateCertificate(istream);
                    istream.close();
                    Document d = KeyConverter.certificateToKeyInfo(cert);
                    xmlres.publish(d, (OutputStream)out);
                } else if (cmd.equals("k2c")) {
                    Document doc = xmlres.parseXML(istream, false);
                    X509Certificate cert = KeyConverter.keyInfoToCertificate(doc, xpath);
                    out.write(cert.getEncoded());
                } else {
                    System.err.println("Don't know what to do with " + cmd);
                    KeyConverter.usage();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                KeyConverter.usage();
            }
        }
    }

    static {
        DIGSIG_NS = DIGSIG_NS;
        DIGSIG_PREFIX = DIGSIG_PREFIX;
        XKMS_NS = XKMS_NS;
        XKMS_PREFIX = XKMS_PREFIX;
        xmlres = ResourceFactory.getXMLResource();
    }
}

