/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Debug;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.elements.X509IssuerSerial;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class X509Data
extends ElementImpl {
    protected static String name = "X509Data";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private X509IssuerSerial issuerSerial = null;
    private byte[] ski = null;
    private String subjectName = null;
    private X509Certificate[] certificate = null;
    private String crl = null;
    private ElementExtension extension = null;

    public X509Data(X509Certificate cert) {
        this.certificate = new X509Certificate[1];
        this.certificate[0] = cert;
    }

    public X509Data(X509Certificate[] chain) {
        this.certificate = new X509Certificate[chain.length];
        System.arraycopy(chain, 0, this.certificate, 0, chain.length);
    }

    private X509Data() {
    }

    X509Data(X509IssuerSerial issuerSerial, byte[] ski, String subjectName, Vector certificateVector, String crl) {
        this.issuerSerial = issuerSerial;
        this.ski = ski;
        this.subjectName = subjectName;
        if (certificateVector != null && certificateVector.size() > 0) {
            this.certificate = new X509Certificate[certificateVector.size()];
            certificateVector.copyInto(this.certificate);
        }
        this.crl = crl;
    }

    public ElementExtension getExtension() {
        return this.extension;
    }

    public void setExtension(ElementExtension extension) {
        this.extension = extension;
    }

    public byte[] getSKI() {
        return this.ski;
    }

    public void setSKI(byte[] ski) {
        this.ski = ski;
    }

    public X509IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate[0];
        }
        return null;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificate;
    }

    public String toString() {
        String s = "[X509Data";
        if (this.issuerSerial != null) {
            s = s + " " + this.issuerSerial;
        }
        if (this.ski != null) {
            s = s + " X509SKI=" + Base64.encode(this.ski);
        }
        if (this.subjectName != null) {
            s = s + " X509SubjectName=" + this.subjectName;
        }
        if (this.certificate != null) {
            int i = 0;
            while (i < this.certificate.length) {
                s = s + " X509Certificate=" + this.certificate[i];
                ++i;
            }
        }
        if (this.crl != null) {
            s = s + " X509CRL=" + this.crl;
        }
        if (this.extension != null) {
            s = s + this.extension;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        DOMWriteCursor wcc;
        wc = wc.addUnder(uri, prefix, name);
        if (this.issuerSerial != null) {
            this.issuerSerial.toXml(wc);
        }
        if (this.ski != null) {
            wcc = wc.addUnder(uri, prefix, "X509SKI");
            wcc.setText(Base64.encode(this.ski));
        }
        if (this.subjectName != null) {
            wcc = wc.addUnder(uri, prefix, "X509SubjectName");
            wcc.setText(this.subjectName);
        }
        try {
            if (this.certificate != null) {
                int i = 0;
                while (i < this.certificate.length) {
                    DOMWriteCursor c = wc.addUnder(uri, prefix, "X509Certificate");
                    c.setText(Base64.encode(this.certificate[i].getEncoded()));
                    ++i;
                }
            }
        }
        catch (CertificateEncodingException e) {
            Debug.out(e.toString(), Debug.MEDIUM);
            throw new IllegalStateException(e.toString());
        }
        if (this.crl != null) {
            DOMWriteCursor wcc2 = wc.addUnder(uri, prefix, "X509CRL");
            wcc2.setText(this.crl);
        }
        if (this.extension != null) {
            this.extension.toXml(wc);
        }
    }

    public static X509Data fromXml(DOMCursor cursor) throws ElementException {
        return X509Data.fromXml(cursor, null);
    }

    public static X509Data fromXml(DOMCursor cursor, ElementExtension ext) throws ElementException {
        DOMCursor cc = ElementImpl.placeCursor(cursor, name, prefix, uri, ns);
        X509IssuerSerial issuerSerial = null;
        if (X509IssuerSerial.isAnElementIn(cc)) {
            issuerSerial = X509IssuerSerial.fromXml(cc);
        }
        byte[] ski = null;
        String subjectName = null;
        String crl = null;
        if (cc.moveToChild(uri, "X509SKI")) {
            ski = Base64.decode(cc.getText());
            cc.moveToParent();
        }
        if (cc.moveToChild(uri, "X509SubjectName")) {
            subjectName = cc.getText();
            cc.moveToParent();
        }
        Vector<Certificate> certificateVector = new Vector<Certificate>();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            DOMCursor c = cc.cloneCursor();
            boolean more = c.moveToChild(uri, "X509Certificate");
            while (more) {
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(c.getText()));
                while (bais.available() > 0) {
                    certificateVector.add(cf.generateCertificate(bais));
                }
                more = c.moveToSibling(uri, "X509Certificate");
            }
        }
        catch (CertificateException e) {
            Debug.out(e.toString(), Debug.MEDIUM);
            throw new ElementException(e.toString());
        }
        if (cc.moveToChild(uri, "X509CRL")) {
            crl = cc.getText();
            cc.moveToParent();
        }
        X509Data kd = new X509Data(issuerSerial, ski, subjectName, certificateVector, crl);
        if (ext != null) {
            ElementExtension e = ext.fromXml(cc);
            kd.setExtension(e);
        }
        return kd;
    }
}

