/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.c14n.CanonicalizerFactory;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.util.Debug;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.elements.HmacOutputLength;
import com.verisign.xmlsig.elements.Transform;
import com.verisign.xmlsig.elements.transforms.CanonicalizationTransform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Transforms
extends ElementImpl {
    private static String name = "Transforms";
    private static String prefix = Namespaces.XMLSIG.getPrefix();
    private static String uri = Namespaces.XMLSIG.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private Vector transformVector = new Vector();

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        Enumeration enumeration = this.transformVector.elements();
        while (enumeration.hasMoreElements()) {
            Transform t = (Transform)enumeration.nextElement();
            t.toXml(wc);
        }
    }

    public static Transforms fromXml(DOMCursor cursor) {
        DOMCursor cc = Transforms.placeCursor(cursor, name, prefix, uri, ns);
        HmacOutputLength hol = HmacOutputLength.fromXml(cc);
        String attributeString = cc.getAttribute("Attribute");
        Transforms transforms = new Transforms();
        boolean exitTransformFound = false;
        Vector<Transform> v = new Vector<Transform>();
        boolean more = cc.moveToChild(Transform.uri, Transform.name);
        while (more) {
            Transform transform = Transform.fromXml(cc);
            if (transform.transformsToOctetStream()) {
                exitTransformFound = true;
            }
            v.add(transform);
            more = cc.moveToSibling(Transform.uri, Transform.name);
        }
        if (!exitTransformFound) {
            v.add(new CanonicalizationTransform());
        }
        transforms.addTransforms(v);
        return transforms;
    }

    private void addTransforms(Vector v) {
        this.transformVector = v;
    }

    public void addTransform(Transform t) {
        this.transformVector.add(t);
    }

    private DOMCursor asCursor(byte[] b) {
        if (Debug.getLevel() >= Debug.HIGH) {
            Debug.out("converting octet stream into node-set", Debug.HIGH);
        }
        XMLResource xmlres = ResourceFactory.getXMLResource();
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        try {
            return new DOMCursor(xmlres.parseXML(is, false));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public byte[] transform(DOMCursor cursor) {
        Transform t;
        boolean copied;
        DOMCursor c;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(cursor);
            c = wc;
            copied = true;
        } else {
            c = cursor.cloneCursor();
            copied = false;
        }
        byte[] bytes = null;
        Enumeration enumeration = this.transformVector.elements();
        while (enumeration.hasMoreElements()) {
            t = (Transform)enumeration.nextElement();
            if (Debug.getLevel() >= Debug.ALL) {
                Debug.out("excuting " + t, Debug.ALL);
            }
            if (t.transformsToOctetStream()) {
                bytes = t.transformToOctetStream(c, cursor);
                break;
            }
            t.transformToNodeSet(c, cursor);
        }
        if (!copied) {
            enumeration = this.transformVector.elements();
            while (enumeration.hasMoreElements()) {
                t = (Transform)enumeration.nextElement();
                t.restoreNodeSet();
            }
        }
        return bytes;
    }

    public byte[] transform(byte[] b) {
        DOMCursor c = null;
        boolean previousReturnedBytes = true;
        Enumeration enumeration = this.transformVector.elements();
        while (enumeration.hasMoreElements()) {
            Transform t = (Transform)enumeration.nextElement();
            if (Debug.getLevel() >= Debug.ALL) {
                Debug.out("excuting " + t, Debug.ALL);
            }
            boolean toBytes = t.transformsToOctetStream();
            if (t.consumesRawOctetStream()) {
                if (!previousReturnedBytes) {
                    this.badState(t, null);
                }
                if (toBytes) {
                    b = t.transformToOctetStream(b);
                } else {
                    c = t.transformToNodeSet(b);
                }
            } else {
                if (previousReturnedBytes) {
                    c = this.asCursor(b);
                }
                if (c == null) {
                    this.badState(t, c);
                }
                if (toBytes) {
                    b = t.transformToOctetStream(c, null);
                } else {
                    c = t.transformToNodeSet(c, null);
                }
            }
            previousReturnedBytes = toBytes;
        }
        return b;
    }

    private void badState(Transform t, DOMCursor c) {
        throw new IllegalStateException("Transformation order mismatch: " + t + " cannot consume input " + c);
    }

    public String toString() {
        String s = "[Transforms";
        Enumeration enumeration = this.transformVector.elements();
        while (enumeration.hasMoreElements()) {
            Transform t = (Transform)enumeration.nextElement();
            s = s + t;
        }
        s = s + "]";
        return s;
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = ElementImpl.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            Debug.out(e.toString(), Debug.ALL);
            return false;
        }
    }
}

