/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.elements.XPathElement;
import com.verisign.xmlsig.elements.transforms.TransformFactory;
import com.verisign.xpath.XPath;

public abstract class Transform
extends ElementImpl {
    protected static String name = "Transform";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    protected XPathElement xPathElement;
    protected ElementExtension extension = null;
    private String algorithmUri;
    private DOMCursor origTransform;

    public abstract boolean transformsToOctetStream();

    public abstract boolean consumesRawOctetStream();

    protected void throwBadState(Transform t, byte[] b) {
        String s = "Transform " + t + " cannot handle " + b + " input";
        throw new UnsupportedOperationException(s);
    }

    protected void throwBadState(Transform t, DOMCursor c) {
        String s = "Transform " + t + " cannot handle " + c + " input";
        throw new UnsupportedOperationException(s);
    }

    public abstract byte[] transformToOctetStream(DOMCursor var1, DOMCursor var2);

    public abstract byte[] transformToOctetStream(byte[] var1);

    public abstract DOMCursor transformToNodeSet(DOMCursor var1, DOMCursor var2);

    public abstract DOMCursor transformToNodeSet(byte[] var1);

    public void restoreNodeSet() {
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.xPathElement != null) {
            this.xPathElement.toXml(wc);
        }
        wc.setAttribute("Algorithm", this.algorithmUri);
        if (this.extension != null) {
            this.extension.toXml(wc);
        }
    }

    public static Transform fromXml(DOMCursor cursor) {
        ElementExtension ext;
        DOMCursor cc = Transform.placeCursor(cursor, name, prefix, uri, ns);
        String algo = cc.getAttribute("Algorithm");
        Transform t = TransformFactory.createTransform(algo);
        t.origTransform = cc.cloneCursor();
        if (XPathElement.isAnElementIn(cc)) {
            t.setXPathElement(XPathElement.fromXml(cc));
        }
        if ((ext = t.createExtension()) != null) {
            ElementExtension e = ext.fromXml(cc);
            t.setExtension(e);
        }
        return t;
    }

    public ElementExtension createExtension() {
        return null;
    }

    public void setExtension(ElementExtension extension) {
        this.extension = extension;
    }

    private void setXPathElement(XPathElement xPathElement) {
        this.xPathElement = xPathElement;
    }

    public Transform(String algorithmUri) {
        this.algorithmUri = algorithmUri;
    }

    public String toString() {
        String s = "[Transform " + this.xPathElement;
        if (this.extension != null) {
            s = s + this.extension;
        }
        return s + "]";
    }

    public DOMCursor getHereLocation(DOMCursor clonedRef, DOMCursor origRef) throws IllegalStateException {
        XPath relPath;
        DOMCursor here = null;
        if (this.origTransform != null && origRef != null && !(relPath = this.origTransform.createXPath(origRef)).getXPath().startsWith("..") && !(here = clonedRef.cloneCursor()).moveToXPath(relPath)) {
            throw new IllegalStateException("Could not recover transform relPath=" + relPath + " origTransform=" + this.origTransform + " origRef=" + origRef + " clonedRef=" + clonedRef);
        }
        return here;
    }
}

