/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.c14n.CanonicalizerFactory;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.resource.DOMOperations;
import com.verisign.util.Debug;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.elements.CanonicalizationMethod;
import com.verisign.xmlsig.elements.Reference;
import com.verisign.xmlsig.elements.SignatureMethod;
import com.verisign.xpath.XPath;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;

public class SignedInfo
extends ElementImpl {
    private static String name = "SignedInfo";
    private static String prefix = Namespaces.XMLSIG.getPrefix();
    private static String uri = Namespaces.XMLSIG.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private static DOMOperations ops = DOMOperations.getInstance();
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private Vector referenceVector = new Vector();
    private String id = null;

    protected void setSignatureMethod(SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public void calculateReferences() {
        Enumeration enumeration = this.referenceVector.elements();
        while (enumeration.hasMoreElements()) {
            Reference ref = (Reference)enumeration.nextElement();
            ref.calculate(false);
        }
    }

    public boolean verifyReferences() {
        Enumeration enumeration = this.referenceVector.elements();
        while (enumeration.hasMoreElements()) {
            Reference ref = (Reference)enumeration.nextElement();
            if (ref.calculate(true)) continue;
            Debug.out("Verify reference " + ref + " failed, " + "digests do not match!", Debug.MEDIUM);
            return false;
        }
        return true;
    }

    public byte[] canonicalize(DOMCursor cursor) {
        Map namespaces;
        DOMCursor c;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(cursor);
            c = this.toXml();
            c = wc.copyUnder(c);
            c.getElement().removeAttribute("xmlns");
            namespaces = null;
        } else {
            c = this.toXml();
            namespaces = ops.getInScopeNamespaces(cursor.getElement());
            namespaces.put(null, "");
        }
        byte[] b = this.canonicalizationMethod.canonicalize(c, namespaces);
        if (Debug.getLevel() >= Debug.ALL) {
            Debug.out(new String(b), Debug.ALL);
        }
        return b;
    }

    public byte[] canonicalize() {
        DOMCursor c = this.toXml();
        byte[] b = this.canonicalizationMethod.canonicalize(c, null);
        if (Debug.getLevel() >= Debug.ALL) {
            Debug.out(new String(b), Debug.ALL);
        }
        return b;
    }

    public byte[] canonicalizeExisting(DOMCursor cursor) {
        DOMCursor c;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(cursor);
            c = wc;
        } else {
            c = cursor.cloneCursor();
        }
        c.moveToChild(uri, name);
        byte[] b = this.canonicalizationMethod.canonicalize(c, null);
        if (Debug.getLevel() >= Debug.ALL) {
            Debug.out(new String(b), Debug.ALL);
        }
        return b;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.id != null) {
            wc.setAttribute("Id", this.id);
        }
        this.canonicalizationMethod.toXml(wc);
        this.signatureMethod.toXml(wc);
        Enumeration enumeration = this.referenceVector.elements();
        while (enumeration.hasMoreElements()) {
            Reference ref = (Reference)enumeration.nextElement();
            ref.toXml(wc);
        }
    }

    public DOMCursor toXml() {
        DOMWriteCursor wc = new DOMWriteCursor();
        this.toXml(wc);
        wc.moveToTop();
        return wc;
    }

    public static SignedInfo fromXml(DOMCursor cursor) {
        DOMCursor cc = SignedInfo.placeCursor(cursor, name, prefix, uri, ns);
        CanonicalizationMethod cm = CanonicalizationMethod.fromXml(cc);
        SignatureMethod sm = SignatureMethod.fromXml(cc);
        Vector<Reference> v = new Vector<Reference>();
        boolean more = cc.moveToChild(Reference.uri, Reference.name);
        while (more) {
            Reference ref = Reference.fromXml(cc);
            v.add(ref);
            more = cc.moveToSibling(Reference.uri, Reference.name);
        }
        SignedInfo signedInfo = new SignedInfo(cm, sm);
        if (v.size() > 0) {
            signedInfo.setReferences(v);
        }
        return signedInfo;
    }

    protected SignedInfo() {
        this.canonicalizationMethod = new CanonicalizationMethod();
        this.signatureMethod = new SignatureMethod();
    }

    private SignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
    }

    public void useExclusiveCanonicalizer(List list) {
        this.canonicalizationMethod = new CanonicalizationMethod(CanonicalizationMethod.ExclusiveCanonicalizationUri, list);
    }

    public void setReferences(Vector v) {
        this.referenceVector = v;
    }

    public Vector getReferences() {
        return this.referenceVector;
    }

    public void addReference(Reference r) {
        this.referenceVector.add(r);
    }

    public boolean isReferenced(XPath xpath) {
        Enumeration enumeration = this.referenceVector.elements();
        while (enumeration.hasMoreElements()) {
            Reference ref = (Reference)enumeration.nextElement();
            if (!ref.isReferenced(xpath)) continue;
            return true;
        }
        return false;
    }

    public Element[] getReferencedElements() {
        ArrayList<Element> list = new ArrayList<Element>(this.referenceVector.size());
        Enumeration enumeration = this.referenceVector.elements();
        while (enumeration.hasMoreElements()) {
            Reference ref = (Reference)enumeration.nextElement();
            Element elem = ref.getElement();
            if (elem == null) continue;
            list.add(elem);
        }
        Element[] elements = new Element[list.size()];
        list.toArray(elements);
        return elements;
    }

    public String toString() {
        String s = "[SignedInfo" + this.canonicalizationMethod + this.signatureMethod;
        Enumeration enumeration = this.referenceVector.elements();
        while (enumeration.hasMoreElements()) {
            Reference ref = (Reference)enumeration.nextElement();
            s = s + ref;
        }
        s = s + "]";
        return s;
    }
}

