/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;

public class SignatureValue
extends ElementImpl {
    private static final String name = "SignatureValue";
    private static final String prefix;
    private static final String uri;
    private static final String[] ns;
    private String id = null;
    private byte[] value = null;

    public void setValue(byte[] value) {
        this.value = value;
    }

    void setId(String id) {
        this.id = id;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.id != null) {
            wc.setAttribute("Id", this.id);
        }
        if (this.value != null) {
            wc.setText(Base64.encode(this.value));
        }
    }

    public static SignatureValue fromXml(DOMCursor cursor) {
        DOMCursor cc = SignatureValue.placeCursor(cursor, name, prefix, uri, ns);
        SignatureValue sv = new SignatureValue();
        String s = cc.getAttribute("Id");
        if (s != null) {
            sv.setId(s);
        }
        sv.setValue(Base64.decode(cc.getText()));
        return sv;
    }

    public String toString() {
        String s = "[SignatureValue";
        if (this.id != null) {
            s = s + " Id=" + this.id;
        }
        if (this.value != null) {
            s = s + " " + Base64.encode(this.value).substring(0, 4) + "...";
        }
        return s + "]";
    }

    static {
        name = name;
        prefix = Namespaces.XMLSIG.getPrefix();
        uri = Namespaces.XMLSIG.getUri();
        ns = new String[]{prefix, uri};
    }
}

