/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.elements.HmacOutputLength;

public class SignatureMethod
extends ElementImpl {
    protected static String name = "SignatureMethod";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private static boolean DEBUG = false;
    private HmacOutputLength hmacOutputLength = null;
    private String algorithmUri;

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.hmacOutputLength != null) {
            this.hmacOutputLength.toXml(wc);
        }
        wc.setAttribute("Algorithm", this.algorithmUri);
    }

    public static SignatureMethod fromXml(DOMCursor cursor) {
        DOMCursor cc = SignatureMethod.placeCursor(cursor, name, prefix, uri, ns);
        HmacOutputLength hol = HmacOutputLength.fromXml(cc);
        String algorithmUri = cc.getAttribute("Algorithm");
        SignatureMethod sm = new SignatureMethod(algorithmUri);
        if (hol != null) {
            sm.setHmacOutputLength(hol);
        }
        return sm;
    }

    protected SignatureMethod(String algorithmUri) {
        this.algorithmUri = algorithmUri;
    }

    protected SignatureMethod() {
        this.algorithmUri = null;
    }

    private void setHmacOutputLength(HmacOutputLength hmacOutputLength) {
        this.hmacOutputLength = hmacOutputLength;
    }

    public String toString() {
        return "[SignatureMethod " + this.algorithmUri + "]";
    }
}

