/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Debug;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.elements.KeyInfo;
import com.verisign.xmlsig.elements.ObjectElement;
import com.verisign.xmlsig.elements.Reference;
import com.verisign.xmlsig.elements.SignatureMethod;
import com.verisign.xmlsig.elements.SignatureValue;
import com.verisign.xmlsig.elements.SignedInfo;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Vector;

public class Signature
extends ElementImpl {
    public static final String name = "Signature";
    public static final String prefix;
    public static final String uri;
    public static final String[] ns;
    private SignedInfo signedInfo;
    private SignatureValue signatureValue;
    private KeyInfo keyInfo = null;
    private Vector objectElementVector = null;
    private SigningKey signingKey = null;
    private VerifyingKey verifyingKey = null;

    public Signature() {
        this.signedInfo = new SignedInfo();
        this.signatureValue = new SignatureValue();
        this.keyInfo = new KeyInfo();
    }

    private Signature(SignedInfo si, SignatureValue sv, KeyInfo ki) {
        this.signedInfo = si;
        this.signatureValue = sv;
        this.keyInfo = ki;
    }

    public static Signature fromXml(DOMCursor cursor) throws ElementException {
        DOMCursor cc = Signature.placeCursor(cursor, name, prefix, uri, ns);
        SignedInfo si = SignedInfo.fromXml(cc);
        SignatureValue sv = SignatureValue.fromXml(cc);
        KeyInfo ki = KeyInfo.fromXml(cc);
        Vector<ObjectElement> v = new Vector<ObjectElement>();
        while (cc.moveToSibling(ObjectElement.uri, ObjectElement.name)) {
            ObjectElement o = ObjectElement.fromXml(cc);
            v.add(o);
        }
        Signature signature = new Signature(si, sv, ki);
        if (v.size() > 0) {
            signature.addObjects(v);
        }
        return signature;
    }

    public void addObjectsFromReferences(Vector v) {
        if (v.size() > 0) {
            this.objectElementVector = new Vector();
        }
        Enumeration enumeration = v.elements();
        while (enumeration.hasMoreElements()) {
            Reference r = (Reference)enumeration.nextElement();
            this.objectElementVector.add(r.getObjectElement());
        }
    }

    public void addObjects(Vector v) {
        this.objectElementVector = v;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public SigningKey getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(SigningKey signingKey) {
        this.signingKey = signingKey;
        SignatureMethod sm = new SignatureMethod(signingKey.getAlgorithmUri());
        this.signedInfo.setSignatureMethod(sm);
    }

    public void setVerifyingKey(VerifyingKey verifyingKey) {
        this.verifyingKey = verifyingKey;
    }

    public void setSignatureValue(byte[] bsig) {
        this.signatureValue.setValue(bsig);
    }

    public boolean verifySignature(byte[] canon) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] sigValue = this.signatureValue.getValue();
        boolean verifies = this.verifyingKey.verifySignature(canon, sigValue);
        if (!verifies) {
            Debug.out("Signature value does not verify", Debug.MEDIUM);
        }
        return verifies;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        this.signedInfo.toXml(wc);
        this.signatureValue.toXml(wc);
        if (this.keyInfo != null) {
            this.keyInfo.toXml(wc);
        }
        if (this.objectElementVector != null) {
            Enumeration enumeration = this.objectElementVector.elements();
            while (enumeration.hasMoreElements()) {
                ObjectElement o = (ObjectElement)enumeration.nextElement();
                o.toXml(wc);
            }
        }
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = ElementImpl.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            Debug.out(e.toString(), Debug.ALL);
            return false;
        }
    }

    public String toString() {
        String s = "[Signature" + this.signedInfo + this.signatureValue;
        if (this.keyInfo != null) {
            s = s + this.keyInfo;
        }
        if (this.objectElementVector != null) {
            Enumeration enumeration = this.objectElementVector.elements();
            while (enumeration.hasMoreElements()) {
                s = s + enumeration.nextElement();
            }
        }
        s = s + "]";
        return s;
    }

    static {
        name = name;
        prefix = Namespaces.XMLSIG.getPrefix();
        uri = Namespaces.XMLSIG.getUri();
        ns = new String[]{prefix, uri};
    }
}

