/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Debug;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.elements.DigestMethod;
import com.verisign.xmlsig.elements.DigestValue;
import com.verisign.xmlsig.elements.ObjectElement;
import com.verisign.xmlsig.elements.Sha1DigestMethod;
import com.verisign.xmlsig.elements.Transform;
import com.verisign.xmlsig.elements.Transforms;
import com.verisign.xmlsig.elements.transforms.CanonicalizationTransform;
import com.verisign.xpath.XPath;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Element;

public class Reference
extends ElementImpl {
    protected static String name = "Reference";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private Transforms transforms;
    private DigestMethod digestMethod;
    private DigestValue digestValue;
    private String id = null;
    private String uriAttr = null;
    private String type = null;
    private DOMCursor targetCursor;
    private ObjectElement objectElement;
    private byte[] uriBytes;

    public void setTarget(DOMCursor targetCursor) {
        this.targetCursor = targetCursor;
    }

    public void setTarget(ObjectElement objectElement) {
        this.objectElement = objectElement;
    }

    private void setTarget(byte[] b) {
        this.uriBytes = b;
    }

    public ObjectElement getObjectElement() {
        return this.objectElement;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.id != null) {
            wc.setAttribute("Id", this.id);
        }
        if (this.uriAttr != null) {
            wc.setAttribute("URI", this.uriAttr);
        }
        if (this.type != null) {
            wc.setAttribute("Type", this.type);
        }
        this.transforms.toXml(wc);
        this.digestMethod.toXml(wc);
        this.digestValue.toXml(wc);
    }

    public static Reference fromXml(DOMCursor cursor) {
        DOMCursor cc = Reference.placeCursor(cursor, name, prefix, uri, ns);
        String id = cc.getAttribute("Id");
        String uriAttr = cc.getAttribute("URI");
        String type = cc.getAttribute("Type");
        int debugLevel = Debug.getLevel();
        Transforms t = null;
        if (Transforms.isAnElementIn(cc)) {
            t = Transforms.fromXml(cc);
        } else if (!Reference.isExternal(uriAttr)) {
            if (debugLevel >= Debug.HIGH) {
                Debug.out("Adding default c14n transform", Debug.HIGH);
            }
            t = new Transforms();
            t.addTransform(new CanonicalizationTransform());
        }
        DigestMethod dm = DigestMethod.fromXml(cc);
        DigestValue dv = DigestValue.fromXml(cc);
        Reference ref = new Reference(t, dm, dv);
        if (id != null) {
            ref.setId(id);
        }
        if (uriAttr != null) {
            ref.setUri(uriAttr);
        }
        if (type != null) {
            ref.setType(type);
        }
        if (debugLevel >= Debug.HIGH) {
            Debug.out("Transform target URI: " + uriAttr, Debug.HIGH);
        }
        if (!Reference.isExternal(uriAttr)) {
            DOMCursor c = cursor.cloneCursor();
            c.moveToTop();
            XPath xpath = Reference.convertToXPath(cc, uriAttr);
            c.moveToTop();
            c.moveToXPath(xpath);
            ref.setTarget(c);
        } else {
            ref.setTarget(Reference.getBytes(uriAttr));
        }
        return ref;
    }

    private static byte[] getBytes(String url) {
        try {
            byte[] b;
            URLConnection conn = new URL(url).openConnection();
            DataInputStream in = new DataInputStream(conn.getInputStream());
            int n = conn.getContentLength();
            if (n != -1) {
                b = new byte[n];
                in.readFully(b);
            } else {
                int c;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    baos.write(c);
                }
                b = baos.toByteArray();
            }
            return b;
        }
        catch (MalformedURLException mue) {
            throw new UnsupportedOperationException(url + " can't be resolved");
        }
        catch (IOException ie) {
            throw new UnsupportedOperationException(ie.toString());
        }
    }

    private static boolean isExternal(String uri) {
        return uri.toLowerCase().startsWith("http");
    }

    private static XPath convertToXPath(DOMCursor c, String uri) {
        if ("".equals(uri)) {
            return new XPath("/*");
        }
        if (uri != null && uri.startsWith("#")) {
            return c.getXPathInContext(uri);
        }
        throw new IllegalArgumentException("Cannot handle reference: " + uri);
    }

    private Reference(Transforms transforms, DigestMethod digestMethod, DigestValue digestValue) {
        this.transforms = transforms;
        this.digestMethod = digestMethod;
        this.digestValue = digestValue;
    }

    public Reference() {
        this.transforms = new Transforms();
        this.digestMethod = new Sha1DigestMethod();
        this.digestValue = new DigestValue();
    }

    private void setId(String id) {
        this.id = id;
    }

    public void setUri(String uriAttr) {
        this.uriAttr = uriAttr;
    }

    private void setType(String type) {
        this.type = type;
    }

    public void addTransform(Transform t) {
        this.transforms.addTransform(t);
    }

    private byte[] evaluateUri() {
        DOMCursor c = this.targetCursor;
        if (c == null && this.objectElement == null && this.uriBytes == null) {
            throw new IllegalStateException("target cannot be null");
        }
        if (this.transforms == null) {
            return this.uriBytes;
        }
        if (this.objectElement != null) {
            c = this.objectElement.toXml();
        }
        if (c == null) {
            return this.transforms.transform(this.uriBytes);
        }
        return this.transforms.transform(c);
    }

    public boolean calculate(boolean verify) {
        byte[] b = this.evaluateUri();
        int debugLevel = Debug.getLevel();
        if (debugLevel >= Debug.ALL) {
            Debug.out("Bytes from transform: " + new String(b), Debug.ALL);
            Debug.out("Bytes base 64: " + Base64.encode(b), Debug.ALL);
        }
        if (debugLevel >= Debug.HIGH) {
            Debug.out("Bytes length: " + b.length, Debug.HIGH);
        }
        b = this.digestMethod.digest(b);
        if (verify) {
            byte[] s = this.digestValue.getBytes();
            if (debugLevel >= Debug.HIGH) {
                Debug.out("Reference digest calculated by the verifier is\n" + Base64.encode(b), Debug.HIGH);
                Debug.out("Reference digest from the XML (calculated by the signer) is\n" + Base64.encode(s), Debug.HIGH);
            }
            if (s.length != b.length) {
                return false;
            }
            int i = 0;
            while (i < s.length) {
                if (s[i] != b[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            if (debugLevel >= Debug.HIGH) {
                Debug.out("Reference digest calculated by the signer is\n" + Base64.encode(b), Debug.HIGH);
            }
            this.digestValue.set(b);
        }
        return true;
    }

    public boolean isReferenced(XPath xpath) {
        if (this.targetCursor == null) {
            return false;
        }
        DOMCursor c = this.targetCursor.cloneCursor();
        c.moveToTop();
        if (!c.moveToXPath(xpath)) {
            return false;
        }
        return this.targetCursor.contains(c);
    }

    public Element getElement() {
        if (this.targetCursor == null) {
            return null;
        }
        return this.targetCursor.getElement();
    }

    public String toString() {
        return "[Reference URI='" + this.uriAttr + "' " + this.transforms + this.digestMethod + this.digestValue + "]";
    }
}

