/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import com.verisign.xmlsig.DSAVerifyingKey;
import com.verisign.xmlsig.RSAVerifyingKey;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.elements.DSAKeyValue;
import com.verisign.xmlsig.elements.RSAKeyValue;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;

public class KeyValue
extends ElementImpl {
    protected static String name = "KeyValue";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private static boolean DEBUG = false;
    private DSAKeyValue dsaKeyValue = null;
    private RSAKeyValue rsaKeyValue = null;

    private KeyValue(DSAKeyValue dsaKeyValue, RSAKeyValue rsaKeyValue) {
        this.dsaKeyValue = dsaKeyValue;
        this.rsaKeyValue = rsaKeyValue;
    }

    public KeyValue(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            this.rsaKeyValue = new RSAKeyValue((RSAPublicKey)publicKey);
        } else if (publicKey instanceof DSAPublicKey) {
            this.dsaKeyValue = new DSAKeyValue((DSAPublicKey)publicKey);
        }
    }

    public PublicKey getPublicKey() {
        try {
            if (this.rsaKeyValue != null) {
                return this.rsaKeyValue.generateRsaPublicKey();
            }
            if (this.dsaKeyValue != null) {
                return this.dsaKeyValue.generateDsaPublicKey();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public VerifyingKey generateVerifyingKey() throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            if (this.rsaKeyValue != null) {
                return new RSAVerifyingKey(this.rsaKeyValue.generateRsaPublicKey());
            }
            if (this.dsaKeyValue != null) {
                return new DSAVerifyingKey(this.dsaKeyValue.generateDsaPublicKey());
            }
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.toString());
        }
        return null;
    }

    public String toString() {
        String s = "[KeyValue";
        if (this.dsaKeyValue != null) {
            s = s + this.dsaKeyValue;
        }
        if (this.rsaKeyValue != null) {
            s = s + this.rsaKeyValue;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.dsaKeyValue != null) {
            this.dsaKeyValue.toXml(wc);
        }
        if (this.rsaKeyValue != null) {
            this.rsaKeyValue.toXml(wc);
        }
    }

    public static KeyValue fromXml(DOMCursor cursor) {
        DOMCursor cc = ElementImpl.placeCursor(cursor, name, prefix, uri, ns);
        DSAKeyValue dsaKeyValue = null;
        if (DSAKeyValue.isAnElementIn(cc)) {
            dsaKeyValue = DSAKeyValue.fromXml(cc);
        }
        RSAKeyValue rsaKeyValue = null;
        if (RSAKeyValue.isAnElementIn(cc)) {
            rsaKeyValue = RSAKeyValue.fromXml(cc);
        }
        return new KeyValue(dsaKeyValue, rsaKeyValue);
    }
}

