/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class DSAKeyValue
extends ElementImpl {
    protected static String name = "DSAKeyValue";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private static boolean DEBUG = false;
    private String p = null;
    private String q = null;
    private String j = null;
    private String g = null;
    private String y = null;
    private String x = null;
    private String seed = null;
    private String pGenCounter = null;

    private DSAKeyValue(String p, String q, String j, String g, String y, String seed, String pGenCounter, String x) {
        this.p = p;
        this.q = q;
        this.j = j;
        this.g = g;
        this.y = y;
        this.x = x;
        this.seed = seed;
        this.pGenCounter = pGenCounter;
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = ElementImpl.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private byte[] fix2Complement(byte[] a) {
        if (a[0] == 0) {
            byte[] b = new byte[a.length - 1];
            System.arraycopy(a, 1, b, 0, a.length - 1);
            return b;
        }
        return a;
    }

    public DSAPublicKey generateDsaPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger Y = new BigInteger(1, this.fix2Complement(Base64.decode(this.y)));
        BigInteger P = new BigInteger(1, this.fix2Complement(Base64.decode(this.p)));
        BigInteger Q = new BigInteger(1, this.fix2Complement(Base64.decode(this.q)));
        BigInteger G = new BigInteger(1, this.fix2Complement(Base64.decode(this.g)));
        KeyFactory dsaKeyFactory = KeyFactory.getInstance("dsa");
        DSAPublicKeySpec kspec = new DSAPublicKeySpec(Y, P, Q, G);
        return (DSAPublicKey)dsaKeyFactory.generatePublic(kspec);
    }

    public DSAPrivateKey generateDsaPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger X = new BigInteger(1, this.fix2Complement(Base64.decode(this.x)));
        BigInteger P = new BigInteger(1, this.fix2Complement(Base64.decode(this.p)));
        BigInteger Q = new BigInteger(1, this.fix2Complement(Base64.decode(this.q)));
        BigInteger G = new BigInteger(1, this.fix2Complement(Base64.decode(this.g)));
        KeyFactory dsaKeyFactory = KeyFactory.getInstance("dsa");
        DSAPrivateKeySpec kspec = new DSAPrivateKeySpec(X, P, Q, G);
        return (DSAPrivateKey)dsaKeyFactory.generatePrivate(kspec);
    }

    public DSAKeyValue(DSAPublicKey key) {
        DSAParams params = key.getParams();
        byte[] b = params.getG().toByteArray();
        b = this.fix2Complement(b);
        this.g = Base64.encode(b);
        b = params.getP().toByteArray();
        b = this.fix2Complement(b);
        this.p = Base64.encode(b);
        b = params.getQ().toByteArray();
        b = this.fix2Complement(b);
        this.q = Base64.encode(b);
        b = key.getY().toByteArray();
        b = this.fix2Complement(b);
        this.y = Base64.encode(b);
    }

    public DSAKeyValue(DSAPrivateKey key) {
        DSAParams params = key.getParams();
        byte[] b = params.getG().toByteArray();
        b = this.fix2Complement(b);
        this.g = Base64.encode(b);
        b = params.getP().toByteArray();
        b = this.fix2Complement(b);
        this.p = Base64.encode(b);
        b = params.getQ().toByteArray();
        b = this.fix2Complement(b);
        this.q = Base64.encode(b);
        b = key.getX().toByteArray();
        b = this.fix2Complement(b);
        this.x = Base64.encode(b);
    }

    public String toString() {
        String s = "[DSAKeyValue";
        if (this.p != null) {
            s = s + " p=" + this.p;
        }
        if (this.q != null) {
            s = s + " q=" + this.q;
        }
        if (this.j != null) {
            s = s + " j=" + this.j;
        }
        if (this.g != null) {
            s = s + " g=" + this.g;
        }
        if (this.y != null) {
            s = s + " y=" + this.y;
        }
        if (this.x != null) {
            s = s + " y=" + this.x;
        }
        if (this.seed != null) {
            s = s + " seed=" + this.seed;
        }
        if (this.pGenCounter != null) {
            s = s + " pGenCounter=" + this.pGenCounter;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        DOMWriteCursor c;
        wc = wc.addUnder(uri, prefix, name);
        if (this.p != null) {
            c = wc.addUnder(uri, prefix, "P");
            c.setText(this.p);
        }
        if (this.q != null) {
            c = wc.addUnder(uri, prefix, "Q");
            c.setText(this.q);
        }
        if (this.j != null) {
            c = wc.addUnder(uri, prefix, "J");
            c.setText(this.j);
        }
        if (this.g != null) {
            c = wc.addUnder(uri, prefix, "G");
            c.setText(this.g);
        }
        if (this.y != null) {
            c = wc.addUnder(uri, prefix, "Y");
            c.setText(this.y);
        }
        if (this.x != null) {
            c = wc.addUnder(uri, prefix, "X");
            c.setText(this.x);
        }
        if (this.seed != null) {
            c = wc.addUnder(uri, prefix, "Seed");
            c.setText(this.seed);
        }
        if (this.pGenCounter != null) {
            c = wc.addUnder(uri, prefix, "PgenCounter");
            c.setText(this.pGenCounter);
        }
    }

    public static DSAKeyValue fromXml(DOMCursor cursor) {
        DOMCursor cc = ElementImpl.placeCursor(cursor, name, prefix, uri, ns);
        String p = null;
        String q = null;
        String j = null;
        String g = null;
        String y = null;
        String x = null;
        String seed = null;
        String pGenCounter = null;
        DOMCursor c = cc.cloneCursor();
        if (c.moveToChild(uri, "P")) {
            p = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "Q")) {
            q = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "J")) {
            j = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "G")) {
            g = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "Y")) {
            y = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "X")) {
            x = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "Seed")) {
            seed = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "PgenCounter")) {
            pGenCounter = c.getText();
        }
        return new DSAKeyValue(p, q, j, g, y, seed, pGenCounter, x);
    }
}

