/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.xmlsig.DSAVerifyingKey;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.RSAVerifyingKey;
import com.verisign.xmlsig.VerifyingKey;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;

public class VerifyingKeyFactory {
    private VerifyingKeyFactory() {
    }

    public static VerifyingKey makeVerifyingKey(KeyInfo keyInfo) throws GeneralSecurityException {
        X509Certificate[] certs = keyInfo.getCertificateChain();
        if (certs != null) {
            return VerifyingKeyFactory.makeVerifyingKey(certs);
        }
        PublicKey key = keyInfo.getKeyValue();
        if (key != null) {
            return VerifyingKeyFactory.makeVerifyingKey(key);
        }
        return null;
    }

    public static VerifyingKey makeVerifyingKey(Key key) throws GeneralSecurityException {
        if (key instanceof RSAPublicKey) {
            return new RSAVerifyingKey((PublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return new DSAVerifyingKey((PublicKey)key);
        }
        return null;
    }

    public static VerifyingKey makeVerifyingKey(X509Certificate[] certs) throws GeneralSecurityException {
        PublicKey key = certs[0].getPublicKey();
        if (key instanceof RSAPublicKey) {
            return new RSAVerifyingKey(certs);
        }
        if (key instanceof DSAPublicKey) {
            return new DSAVerifyingKey(certs);
        }
        return null;
    }
}

