/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.util.Debug;
import com.verisign.xmlsig.DSAVerifyingKey;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.RSAVerifyingKey;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.elements.KeyValue;
import com.verisign.xmlsig.elements.Signature;
import com.verisign.xmlsig.elements.SignedInfo;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Verifier {
    private DOMCursor cursor;
    private Signature signature;
    private byte[] canon;
    private long canonTime = 0L;
    private long cursorTime = 0L;
    private long moveTime = 0L;
    private long fromXmlTime = 0L;
    private VerifyingKey verifyingKey = null;

    public Verifier(Document doc, XPath signatureLocation) throws XPathException, NoSuchAlgorithmException {
        boolean doTimes;
        boolean bl = doTimes = Debug.getLevel() >= Debug.HIGH;
        if (doc == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        if (signatureLocation == null) {
            throw new IllegalArgumentException("signature location cannot be null");
        }
        long t = 0L;
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.cursor = new DOMCursor(doc);
        if (doTimes) {
            this.cursorTime = System.currentTimeMillis() - t;
            t = System.currentTimeMillis();
        }
        this.cursor = this.moveCursor(this.cursor, signatureLocation);
        if (doTimes) {
            this.moveTime = System.currentTimeMillis() - t;
        }
        try {
            if (doTimes) {
                t = System.currentTimeMillis();
            }
            this.signature = Signature.fromXml(this.cursor);
            if (doTimes) {
                this.fromXmlTime = System.currentTimeMillis() - t;
            }
        }
        catch (ElementException e) {
            throw new IllegalArgumentException(e.toString());
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.canon = signedInfo.canonicalizeExisting(this.cursor);
        if (doTimes) {
            this.canonTime = System.currentTimeMillis() - t;
        }
    }

    public void setDebug(PrintStream out, int level) {
        Debug.setLevel(level);
        Debug.setPrintStream(out);
    }

    private DOMCursor moveCursor(DOMCursor cursor, XPath xp) throws XPathException {
        if (!cursor.moveToXPath(xp) || !"Signature".equals(cursor.getLocalName())) {
            throw new XPathException("XPath expression '" + xp.getXPath() + "'" + " does not evaluate to " + Signature.uri + ":" + "Signature");
        }
        return cursor;
    }

    public boolean verify() throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        PublicKey publicKey = this.getVerifyingKey();
        if (publicKey == null) {
            throw new InvalidKeyException("No verification key set");
        }
        return this.verify(publicKey);
    }

    public boolean verify(PublicKey pubKey) throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        if (pubKey == null) {
            throw new InvalidKeyException("No verification key set");
        }
        this.verifyingKey = this.createVerifyingKey(pubKey);
        this.signature.setVerifyingKey(this.verifyingKey);
        return this.internalVerify();
    }

    public boolean verify(VerifyingKey verKey) throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        if (verKey == null) {
            throw new InvalidKeyException("No verification key set");
        }
        this.verifyingKey = verKey;
        this.signature.setVerifyingKey(this.verifyingKey);
        return this.internalVerify();
    }

    private boolean internalVerify() throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        SignedInfo signedInfo;
        String[] ns;
        XPath xp;
        int debugLevel = Debug.getLevel();
        boolean doTimes = debugLevel >= Debug.HIGH;
        DOMCursor c = this.cursor.cloneCursor();
        if (c.moveToXPath(xp = new XPath("./ds:KeyInfo", ns = new String[]{"ds", "http://www.w3.org/2000/09/xmldsig#"}))) {
            this.verifyingKey.readKeyInfo(c.getElement());
        }
        if (!(signedInfo = this.signature.getSignedInfo()).verifyReferences()) {
            return false;
        }
        if (debugLevel >= Debug.HIGH) {
            Debug.out("canonical form = " + new String(this.canon), Debug.HIGH);
        }
        long startTime = 0L;
        if (doTimes) {
            startTime = System.currentTimeMillis();
        }
        boolean b = this.signature.verifySignature(this.canon);
        if (doTimes) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Debug.out("Time to verify: " + (elapsedTime + this.canonTime + this.cursorTime + this.moveTime + this.fromXmlTime) + " ms, of which c14n: " + this.canonTime + " curs:" + this.cursorTime + " move: " + this.moveTime + " fromXml:" + this.fromXmlTime, Debug.HIGH);
        }
        return b;
    }

    public boolean isReferenced(XPath xpath) {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        return signedInfo.isReferenced(xpath);
    }

    public Element[] getReferencedElements() {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        return signedInfo.getReferencedElements();
    }

    private VerifyingKey createVerifyingKey(PublicKey verifyingKey) throws InvalidKeyException {
        VerifyingKey verKey;
        if (verifyingKey instanceof RSAPublicKey) {
            verKey = new RSAVerifyingKey(verifyingKey);
        } else if (verifyingKey instanceof DSAPublicKey) {
            verKey = new DSAVerifyingKey(verifyingKey);
        } else {
            throw new IllegalArgumentException("unknown signing key type");
        }
        return verKey;
    }

    public PublicKey getVerifyingKey() throws XPathException, InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = this.internalGetVerifyingKey();
        X509Certificate cert = this.internalGetCertificate();
        if (cert == null) {
            return publicKey;
        }
        if (this.compare(cert, publicKey) != null) {
            return publicKey;
        }
        return null;
    }

    private PublicKey internalGetVerifyingKey() throws XPathException, InvalidKeyException, NoSuchAlgorithmException {
        com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
        KeyValue keyValue = keyInfo.getKeyValue();
        if (keyValue == null) {
            throw new InvalidKeyException("No verifying key available");
        }
        VerifyingKey r = keyValue.generateVerifyingKey();
        if (r instanceof RSAVerifyingKey) {
            return ((RSAVerifyingKey)r).getPublicKey();
        }
        if (r instanceof DSAVerifyingKey) {
            return ((DSAVerifyingKey)r).getPublicKey();
        }
        return null;
    }

    public X509Certificate getCertificate() throws XPathException {
        PublicKey publicKey = null;
        try {
            publicKey = this.internalGetVerifyingKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.compare(this.internalGetCertificate(), publicKey);
    }

    private X509Certificate compare(X509Certificate cert, PublicKey publicKey) {
        if (cert == null || publicKey == null) {
            return cert;
        }
        if (!Arrays.equals(publicKey.getEncoded(), cert.getPublicKey().getEncoded())) {
            Debug.out("Certificate's key differs from key in KeyInfo", Debug.MEDIUM);
            return null;
        }
        return cert;
    }

    private X509Certificate internalGetCertificate() throws XPathException {
        com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
        return keyInfo.getCertificate();
    }

    public X509Certificate[] getCertificateChain() throws XPathException {
        com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
        X509Certificate[] certs = keyInfo.getCertificateChain();
        if (certs == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            publicKey = this.internalGetVerifyingKey();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.compare(certs[0], publicKey) != null) {
            return certs;
        }
        Debug.out("Leaf certificate's key differs from key in KeyInfo", Debug.MEDIUM);
        return null;
    }

    public KeyInfo getKeyInfo() {
        com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
        if (keyInfo != null) {
            return keyInfo.getKeyInfo();
        }
        return null;
    }
}

