/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.c14n.CanonicalizerFactory;
import com.verisign.c14n.elements.InclusiveNamespacesElement;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.util.Debug;
import com.verisign.xmlsig.DSASigningKey;
import com.verisign.xmlsig.HardwarePrivateKey;
import com.verisign.xmlsig.HardwareSigningKey;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.RSASigningKey;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.elements.ObjectElement;
import com.verisign.xmlsig.elements.Reference;
import com.verisign.xmlsig.elements.Signature;
import com.verisign.xmlsig.elements.SignedInfo;
import com.verisign.xmlsig.elements.transforms.CanonicalizationTransform;
import com.verisign.xmlsig.elements.transforms.EnvelopedTransform;
import com.verisign.xmlsig.elements.transforms.ExclusiveC14nTransform;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;

public class Signer {
    private Vector refs = new Vector();
    private DOMWriteCursor writeCursor = null;
    private Signature signature;
    private Document document;
    private List inclusivePrefixList = null;
    private boolean inPlace = false;

    public void useExclusiveCanonicalizer(List list) {
        if (list == null) {
            throw new IllegalArgumentException("list cannot be null");
        }
        if (Debug.getLevel() >= Debug.HIGH) {
            Debug.out("using exclusive c14n, include prefix:" + list, Debug.HIGH);
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        signedInfo.useExclusiveCanonicalizer(list);
        this.inclusivePrefixList = new Vector(list);
    }

    public Signer(Document doc, PrivateKey signingKey, PublicKey verificationKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, this.createSigningKey(signingKey), verificationKey);
    }

    public Signer(Document doc, PrivateKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, this.createSigningKey(signingKey));
    }

    public Signer(Document doc, SigningKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, signingKey);
    }

    public Signer(Document doc, SigningKey signingKey, VerifyingKey verifyingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, signingKey, verifyingKey);
    }

    public Signer(Document doc, PrivateKey signingKey, X509Certificate[] certificateChain) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        if (certificateChain == null || certificateChain[0] == null) {
            throw new IllegalArgumentException("certificate chain cannot be null");
        }
        this.create(doc, this.createSigningKey(signingKey));
        this.setCertificateChain(certificateChain);
    }

    public Signer(Document doc, PrivateKey signingKey, X509Certificate certificate) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        this.create(doc, this.createSigningKey(signingKey));
        this.setCertificate(certificate);
    }

    public Signer(Document doc, SigningKey signingKey, KeyInfo keyInfo) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.create(doc, signingKey);
        this.setKeyInfo(keyInfo);
    }

    public Signer(Document doc, PrivateKey signingKey, KeyInfo keyInfo) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.create(doc, this.createSigningKey(signingKey));
        this.setKeyInfo(keyInfo);
    }

    private void create(Document doc, SigningKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, signingKey, (PublicKey)null);
    }

    private void create(Document doc, SigningKey signingKey, PublicKey verificationKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.createSignature(doc, signingKey);
        if (verificationKey != null) {
            com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
            keyInfo.addKeyValue(verificationKey);
        }
    }

    private void createWriteCursor() {
        if (this.writeCursor != null) {
            return;
        }
        int debugLevel = Debug.getLevel();
        if (this.inPlace) {
            if (debugLevel >= Debug.ALL) {
                Debug.out("signing in place", Debug.ALL);
            }
            this.writeCursor = new DOMWriteCursor(this.document);
        } else {
            if (debugLevel >= Debug.ALL) {
                Debug.out("signing new document", Debug.ALL);
            }
            DOMCursor foo = new DOMCursor(this.document);
            this.writeCursor = new DOMWriteCursor();
            this.writeCursor.copyUnder(foo);
        }
    }

    private void create(Document doc, SigningKey signingKey, final VerifyingKey verifyingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.createSignature(doc, signingKey);
        if (verifyingKey != null) {
            com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
            keyInfo.setExtension(new ElementExtension(){

                public void toXml(DOMWriteCursor c) {
                    verifyingKey.writeKeyInfo(c.getElement());
                }

                public ElementExtension fromXml(DOMCursor cursor) {
                    return null;
                }
            });
        }
    }

    private void createSignature(Document doc, SigningKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        if (doc == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        this.document = doc;
        if (signingKey == null) {
            throw new IllegalArgumentException("signing key cannot be null");
        }
        this.signature = new Signature();
        this.signature.setSigningKey(signingKey);
    }

    private SigningKey createSigningKey(PrivateKey signingKey) throws InvalidKeyException {
        SigningKey sigKey;
        if (signingKey instanceof RSAPrivateKey) {
            sigKey = new RSASigningKey(signingKey);
        } else if (signingKey instanceof DSAPrivateKey) {
            sigKey = new DSASigningKey(signingKey);
        } else if (signingKey instanceof HardwarePrivateKey) {
            sigKey = new HardwareSigningKey(signingKey);
        } else {
            throw new IllegalArgumentException("unknown signing key type");
        }
        return sigKey;
    }

    private void checkXPathExpression(XPath xpath) throws XPathException {
        String s = xpath.getXPath();
        if ("".equals(s)) {
            throw new XPathException("Empty XPath expression is not allowed");
        }
        if (s.indexOf("here()") != -1) {
            throw new XPathException("'here()' function cannot be used. Expression '" + s + "' is illegal.");
        }
        if (s.startsWith("..")) {
            throw new XPathException("Relative XPath expression '" + s + "' is not allowed");
        }
        DOMCursor foo = new DOMCursor(this.document);
        try {
            foo.moveToXPath(xpath);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(e.toString());
        }
    }

    public void setDebug(PrintStream out, int level) {
        Debug.setLevel(level);
        Debug.setPrintStream(out);
    }

    public void addReference(XPath xpath) {
        this.refs.addElement(xpath);
    }

    private void setCertificate(X509Certificate certificate) throws CertificateException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
        keyInfo.addCertificate(certificate);
        keyInfo.explodeCertificate();
    }

    private void setKeyInfo(KeyInfo keyInfo) throws CertificateException {
        if (keyInfo != null) {
            this.signature.setKeyInfo(new com.verisign.xmlsig.elements.KeyInfo(keyInfo));
        }
    }

    private void setCertificateChain(X509Certificate[] certificateChain) throws CertificateException {
        if (certificateChain == null) {
            throw new IllegalArgumentException("chain cannot be null");
        }
        if (certificateChain[0] == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        com.verisign.xmlsig.elements.KeyInfo keyInfo = this.signature.getKeyInfo();
        keyInfo.addCertificateChain(certificateChain);
        keyInfo.explodeCertificate();
    }

    private void addC14nTransform(Reference r) {
        if (this.inclusivePrefixList != null) {
            InclusiveNamespacesElement elemExt = new InclusiveNamespacesElement(this.inclusivePrefixList);
            ExclusiveC14nTransform t = new ExclusiveC14nTransform();
            t.setExtension(elemExt);
            r.addTransform(t);
        } else {
            r.addTransform(new CanonicalizationTransform());
        }
    }

    public void signInPlace() throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        this.inPlace = true;
        this.sign();
    }

    public Document sign() throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        int debugLevel = Debug.getLevel();
        boolean doTimes = debugLevel >= Debug.HIGH;
        long startTime = 0L;
        if (doTimes) {
            startTime = System.currentTimeMillis();
        }
        this.createWriteCursor();
        int size = this.refs.size();
        if (size == 0) {
            XPath xp = new XPath("/*");
            this.addReference(xp);
        }
        Vector<DOMCursor> targets = new Vector<DOMCursor>();
        size = this.refs.size();
        int i = 0;
        while (i < size) {
            XPath xp = (XPath)this.refs.elementAt(i);
            this.checkXPathExpression(xp);
            DOMCursor c = this.writeCursor.cloneCursor();
            if (!c.moveToXPath(xp)) {
                throw new XPathException("XPath expression '" + xp.getXPath() + "'" + " evaluates to nothing");
            }
            targets.add(c);
            ++i;
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Enumeration enumeration = targets.elements();
        int i2 = 1;
        while (enumeration.hasMoreElements()) {
            DOMCursor c = (DOMCursor)enumeration.nextElement();
            Reference r = new Reference();
            this.addC14nTransform(r);
            ObjectElement o = new ObjectElement();
            o.setElementCursor(c);
            r.setUri("#xpointer(/ds:Signature/ds:Object[" + i2 + "])");
            r.setTarget(o);
            signedInfo.addReference(r);
            ++i2;
        }
        this.signature.addObjectsFromReferences(signedInfo.getReferences());
        signedInfo.calculateReferences();
        byte[] canon = signedInfo.canonicalize();
        SigningKey signingKey = this.signature.getSigningKey();
        byte[] bsig = signingKey.signData(canon);
        this.signature.setSignatureValue(bsig);
        if (debugLevel >= Debug.ALL) {
            Debug.out("sign=" + this.signature, Debug.ALL);
        }
        DOMWriteCursor tempCursor = new DOMWriteCursor();
        long t = 0L;
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.signature.toXml(tempCursor);
        long toXmlTime = 0L;
        if (doTimes) {
            toXmlTime = System.currentTimeMillis() - t;
            t = System.currentTimeMillis();
        }
        if (this.inPlace) {
            this.writeCursor.moveToTop();
            this.writeCursor.remove();
            this.writeCursor.copyUnder(tempCursor);
        } else {
            this.writeCursor = tempCursor;
        }
        long elapsedTime = 0L;
        if (doTimes) {
            long copyTime = System.currentTimeMillis() - t;
            elapsedTime = System.currentTimeMillis() - startTime;
            Debug.out("Time to sign: " + elapsedTime + " ms, of which toXml: " + toXmlTime + " copy: " + copyTime, Debug.HIGH);
        }
        return this.writeCursor.getDocument();
    }

    public Document sign(XPath xpath) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        return this.sign(xpath, false);
    }

    public void signInPlace(XPath xpath) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        this.inPlace = true;
        this.sign(xpath, false);
    }

    public void signInPlace(XPath xpath, boolean insertBefore) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        this.inPlace = true;
        this.sign(xpath, insertBefore);
    }

    public Document sign(XPath xpath, boolean insertBefore) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        byte[] canon;
        int debugLevel = Debug.getLevel();
        boolean doTimes = debugLevel >= Debug.HIGH;
        long startTime = 0L;
        if (doTimes) {
            startTime = System.currentTimeMillis();
        }
        this.createWriteCursor();
        this.writeCursor.moveToTop();
        this.checkXPathExpression(xpath);
        if (!this.writeCursor.moveToXPath(xpath)) {
            throw new XPathException("XPath expression '" + xpath.getXPath() + "'" + " evaluates to nothing");
        }
        int size = this.refs.size();
        if (size == 0) {
            XPath xp = new XPath("/");
            this.addReference(xp);
        }
        Vector<DOMCursor> targets = new Vector<DOMCursor>();
        Hashtable<DOMCursor, XPath> map = new Hashtable<DOMCursor, XPath>();
        size = this.refs.size();
        int i = 0;
        while (i < size) {
            XPath xp = (XPath)this.refs.elementAt(i);
            this.checkXPathExpression(xp);
            DOMCursor c = this.writeCursor.cloneCursor();
            if (!c.moveToXPath(xp)) {
                throw new XPathException("XPath expression '" + xp.getXPath() + "'" + " evaluates to nothing");
            }
            targets.add(c);
            map.put(c, xp);
            ++i;
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Enumeration enumeration = targets.elements();
        while (enumeration.hasMoreElements()) {
            DOMCursor c = (DOMCursor)enumeration.nextElement();
            Reference r = new Reference();
            boolean needEnveloped = insertBefore ? !c.equals(this.writeCursor) && c.contains(this.writeCursor) : c.contains(this.writeCursor);
            if (needEnveloped) {
                if (debugLevel >= Debug.HIGH) {
                    Debug.out("Adding enveloped transform", Debug.HIGH);
                }
                r.addTransform(new EnvelopedTransform());
            }
            this.addC14nTransform(r);
            r.setTarget(c);
            XPath refXPath = (XPath)map.get(c);
            String foo = refXPath.getXPath();
            foo = "/".equals(foo) ? "" : refXPath.toXPointer();
            r.setUri(foo);
            signedInfo.addReference(r);
        }
        signedInfo.calculateReferences();
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor foo = new DOMWriteCursor();
            foo.copyUnder(this.writeCursor);
            foo = foo.addUnder(null, null, "temp");
            canon = signedInfo.canonicalize(foo);
        } else {
            canon = signedInfo.canonicalize(this.writeCursor);
        }
        if (debugLevel >= Debug.HIGH) {
            Debug.out("canonical form = " + new String(canon), Debug.HIGH);
        }
        SigningKey signingKey = this.signature.getSigningKey();
        byte[] bsig = signingKey.signData(canon);
        this.signature.setSignatureValue(bsig);
        if (debugLevel >= Debug.ALL) {
            Debug.out("sign=" + this.signature, Debug.ALL);
        }
        DOMWriteCursor wc = new DOMWriteCursor();
        long t = 0L;
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.signature.toXml(wc);
        long toXmlTime = 0L;
        if (doTimes) {
            toXmlTime = System.currentTimeMillis() - t;
        }
        if (insertBefore) {
            this.writeCursor.copyBefore(wc);
        } else {
            this.writeCursor.copyUnder(wc);
        }
        if (doTimes) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Debug.out("Time to sign: " + elapsedTime + " ms, of which toXml: " + toXmlTime, Debug.HIGH);
        }
        return this.writeCursor.getDocument();
    }
}

